/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.CableUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineChemicalTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TurbineMultiblockData
extends MultiblockData {
    public static final float ROTATION_THRESHOLD = 0.001f;
    public static final Object2FloatMap<UUID> clientRotationMap = new Object2FloatOpenHashMap();
    private final List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> fluidOutputTargets = new ArrayList<BlockCapabilityCache<IFluidHandler, Direction>>();
    private final List<BlockEnergyCapabilityCache> energyOutputTargets = new ArrayList<BlockEnergyCapabilityCache>();
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"}, docPlaceholder="steam tank")
    public IChemicalTank chemicalTank;
    @ContainerSync
    public IExtendedFluidTank ventTank;
    @ContainerSync
    public IEnergyContainer energyContainer;
    @ContainerSync
    @SyntheticComputerMethod(getter="getDumpingMode")
    public TileEntityChemicalTank.GasMode dumpMode = TileEntityChemicalTank.GasMode.IDLE;
    private long energyCapacity = 0L;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBlades")
    public int blades;
    @ContainerSync
    @SyntheticComputerMethod(getter="getVents")
    public int vents;
    private List<VentData> ventData = Collections.emptyList();
    @ContainerSync
    @SyntheticComputerMethod(getter="getCoils")
    public int coils;
    @ContainerSync
    @SyntheticComputerMethod(getter="getCondensers")
    public int condensers;
    @ContainerSync
    public int lowerVolume;
    public BlockPos complex;
    @ContainerSync
    @SyntheticComputerMethod(getter="getLastSteamInputRate")
    public long lastSteamInput;
    public long newSteamInput;
    @ContainerSync
    @SyntheticComputerMethod(getter="getFlowRate")
    public long clientFlow;
    public float clientRotation;
    public float prevSteamScale;

    public TurbineMultiblockData(TileEntityTurbineCasing tile) {
        super((BlockEntity)tile);
        this.chemicalTank = new TurbineChemicalTank(this, this.createSaveAndComparator());
        this.chemicalTanks.add(this.chemicalTank);
        this.ventTank = VariableCapacityFluidTank.output((MultiblockData)this, () -> this.isFormed() ? this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get() : 1000, fluid -> fluid.is(FluidTags.WATER), (IContentsListener)this);
        this.fluidTanks.add(this.ventTank);
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getEnergyCapacity, automationType -> this.isFormed(), automationType -> automationType == AutomationType.INTERNAL && this.isFormed(), (IContentsListener)this);
        this.energyContainers.add(this.energyContainer);
    }

    protected void updateEjectors(Level world) {
        this.fluidOutputTargets.clear();
        this.energyOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityTurbineValve tile = (TileEntityTurbineValve)WorldUtils.getTileEntity(TileEntityTurbineValve.class, (BlockGetter)world, (BlockPos)valve.location);
            if (tile == null) continue;
            tile.addEnergyTargetCapability(this.energyOutputTargets, valve.side);
        }
        for (VentData data : this.ventData) {
            TileEntityTurbineVent vent = (TileEntityTurbineVent)WorldUtils.getTileEntity(TileEntityTurbineVent.class, (BlockGetter)world, (BlockPos)data.location);
            if (vent == null) continue;
            vent.addFluidTargetCapability(this.fluidOutputTargets, data.side);
        }
    }

    public boolean tick(Level world) {
        float scale;
        float newRotation;
        boolean needsPacket = super.tick(world);
        this.lastSteamInput = this.newSteamInput;
        this.newSteamInput = 0L;
        long stored = this.chemicalTank.getStored();
        double flowRate = 0.0;
        long energyNeeded = this.energyContainer.getNeeded();
        if (stored > 0L && energyNeeded > 0L) {
            double energyMultiplier = (double)MekanismConfig.general.maxEnergyPerSteam.get() / 28.0 * (double)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get());
            if (energyMultiplier < (double)1.0E-5f) {
                this.clientFlow = 0L;
            } else {
                double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get());
                rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get());
                double proportion = (double)stored / (double)this.getSteamCapacity();
                double origRate = rate;
                rate = Math.min(Math.min((double)stored, rate), (double)energyNeeded / energyMultiplier) * proportion;
                this.clientFlow = MathUtils.clampToLong((double)rate);
                if (this.clientFlow > 0L) {
                    flowRate = rate / origRate;
                    this.energyContainer.insert(MathUtils.clampToLong((double)(energyMultiplier * rate)), Action.EXECUTE, AutomationType.INTERNAL);
                    this.chemicalTank.shrinkStack(this.clientFlow, Action.EXECUTE);
                    this.ventTank.insert(new FluidStack((Fluid)Fluids.WATER, Math.min(MathUtils.clampToInt((double)rate), this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get())), Action.EXECUTE, AutomationType.INTERNAL);
                }
            }
        } else {
            this.clientFlow = 0L;
        }
        if (!this.fluidOutputTargets.isEmpty() && !this.ventTank.isEmpty()) {
            this.ventTank.extract(FluidUtils.emit(this.fluidOutputTargets, (FluidStack)this.ventTank.getFluid()), Action.EXECUTE, AutomationType.INTERNAL);
        }
        CableUtils.emit(this.energyOutputTargets, (IEnergyContainer)this.energyContainer);
        if (this.dumpMode != TileEntityChemicalTank.GasMode.IDLE && !this.chemicalTank.isEmpty()) {
            long amount = this.chemicalTank.getStored();
            if (this.dumpMode == TileEntityChemicalTank.GasMode.DUMPING) {
                this.chemicalTank.shrinkStack(this.getDumpingAmount(amount), Action.EXECUTE);
            } else {
                long targetLevel = MathUtils.clampToLong((double)((double)this.chemicalTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (targetLevel < amount) {
                    this.chemicalTank.shrinkStack(Math.min(amount - targetLevel, this.getDumpingAmount(amount)), Action.EXECUTE);
                }
            }
        }
        if (Math.abs((newRotation = (float)flowRate) - this.clientRotation) > 0.001f) {
            this.clientRotation = newRotation;
            needsPacket = true;
        }
        if (MekanismUtils.scaleChanged((float)(scale = MekanismUtils.getScale((float)this.prevSteamScale, (IChemicalTank)this.chemicalTank)), (float)this.prevSteamScale)) {
            needsPacket = true;
            this.prevSteamScale = scale;
        }
        return needsPacket;
    }

    private long getDumpingAmount(long stored) {
        return Math.min(stored, Math.max(stored / 50L, this.lastSteamInput * 2L));
    }

    public void updateVentData(List<VentData> vents) {
        this.ventData = vents;
        this.vents = this.ventData.size();
    }

    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"volume", this::setVolume);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"lower_volume", value -> {
            this.lowerVolume = value;
        });
        NBTUtils.setChemicalStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"chemical", value -> this.chemicalTank.setStack(value));
        NBTUtils.setFluidStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"fluid", arg_0 -> ((IExtendedFluidTank)this.ventTank).setStack(arg_0));
        NBTUtils.setBlockPosIfPresent((CompoundTag)tag, (String)"complex", value -> {
            this.complex = value;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"rotation", value -> {
            this.clientRotation = value;
        });
        clientRotationMap.put((Object)this.inventoryID, this.clientRotation);
    }

    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        tag.putFloat("scale", this.prevSteamScale);
        tag.putInt("volume", this.getVolume());
        tag.putInt("lower_volume", this.lowerVolume);
        tag.put("chemical", this.chemicalTank.getStack().saveOptional(provider));
        tag.put("fluid", this.ventTank.getFluid().saveOptional(provider));
        tag.put("complex", NbtUtils.writeBlockPos((BlockPos)this.complex));
        tag.putFloat("rotation", this.clientRotation);
    }

    @ComputerMethod
    public int getDispersers() {
        return (this.length() - 2) * (this.width() - 2) - 1;
    }

    public long getSteamCapacity() {
        return (long)this.lowerVolume * MekanismGeneratorsConfig.generators.turbineChemicalPerTank.get();
    }

    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    public void setVolume(int volume) {
        if (this.getVolume() != volume) {
            super.setVolume(volume);
            this.energyCapacity = (long)volume * MekanismGeneratorsConfig.generators.turbineEnergyCapacityPerVolume.get();
        }
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.chemicalTank.getStored(), (long)this.chemicalTank.getCapacity());
    }

    @ComputerMethod
    public long getProductionRate() {
        double energyMultiplier = (double)MekanismConfig.general.maxEnergyPerSteam.get() / 28.0 * (double)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get());
        return MathUtils.clampToLong((double)(energyMultiplier * (double)this.clientFlow));
    }

    @ComputerMethod
    public long getMaxProduction() {
        double energyMultiplier = (double)MekanismConfig.general.maxEnergyPerSteam.get() / 28.0 * (double)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get());
        double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get());
        rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get());
        return MathUtils.clampToLong((double)(energyMultiplier * rate));
    }

    @ComputerMethod
    public long getMaxFlowRate() {
        double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get());
        rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get());
        return MathUtils.clampToLong((double)rate);
    }

    @ComputerMethod
    public long getMaxWaterOutput() {
        return (long)this.condensers * (long)MekanismGeneratorsConfig.generators.condenserRate.get();
    }

    @ComputerMethod(nameOverride="setDumpingMode")
    public void setDumpMode(TileEntityChemicalTank.GasMode mode) {
        if (this.dumpMode != mode) {
            this.dumpMode = mode;
            this.markDirty();
        }
    }

    @ComputerMethod
    void incrementDumpingMode() {
        this.setDumpMode((TileEntityChemicalTank.GasMode)this.dumpMode.getNext());
    }

    @ComputerMethod
    void decrementDumpingMode() {
        this.setDumpMode((TileEntityChemicalTank.GasMode)this.dumpMode.getPrevious());
    }

    public record VentData(BlockPos location, Direction side) {
    }
}

