/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.registries;

import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.registries.MekanismBlocks;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GeneratorsBuilders {
    private GeneratorsBuilders() {
    }

    public static class FusionReactorBuilder
    extends StructureBuilder {
        public FusionReactorBuilder() {
            super(5, 5, 5);
        }

        protected void build(Level world, BlockPos start, boolean empty) {
            this.buildPartialFrame(world, start, 1);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 3, Blocks.AIR.defaultBlockState());
            world.setBlockAndUpdate(start.offset(2, 4, 2), GeneratorsBlocks.FUSION_REACTOR_CONTROLLER.defaultState());
        }

        protected BlockState getWallBlock(BlockPos pos) {
            return GeneratorsBlocks.FUSION_REACTOR_FRAME.defaultState();
        }

        protected BlockState getCasing() {
            return GeneratorsBlocks.FUSION_REACTOR_FRAME.defaultState();
        }
    }

    public static class FissionReactorBuilder
    extends StructureBuilder {
        public FissionReactorBuilder() {
            super(18, 18, 18);
        }

        protected void build(Level world, BlockPos start, boolean empty) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            if (empty) {
                this.buildInteriorLayers(world, start, 1, 16, Blocks.AIR.defaultBlockState());
            } else {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int x = 1; x < this.sizeX - 1; ++x) {
                    for (int z = 1; z < this.sizeZ - 1; ++z) {
                        mutablePos.set(x, 1, z);
                        if (x % 2 == z % 2) {
                            this.buildColumn(world, start, (BlockPos)mutablePos, 15, GeneratorsBlocks.FISSION_FUEL_ASSEMBLY.defaultState());
                            mutablePos.setWithOffset((Vec3i)start, x, this.sizeY - 2, z);
                            world.setBlockAndUpdate((BlockPos)mutablePos, GeneratorsBlocks.CONTROL_ROD_ASSEMBLY.defaultState());
                            continue;
                        }
                        this.buildColumn(world, start, (BlockPos)mutablePos, 16, Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }

        protected BlockState getWallBlock(BlockPos pos) {
            return GeneratorsBlocks.REACTOR_GLASS.defaultState();
        }

        protected BlockState getCasing() {
            return GeneratorsBlocks.FISSION_REACTOR_CASING.defaultState();
        }
    }

    public static class TurbineBuilder
    extends StructureBuilder {
        public TurbineBuilder() {
            super(17, 18, 17);
        }

        protected void build(Level world, BlockPos start, boolean empty) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 14, Blocks.AIR.defaultBlockState());
            if (empty) {
                this.buildInteriorLayers(world, start, 15, 16, Blocks.AIR.defaultBlockState());
            } else {
                this.buildColumn(world, start, new BlockPos(this.sizeX / 2, 1, this.sizeZ / 2), 14, GeneratorsBlocks.TURBINE_ROTOR.defaultState(), TileEntityTurbineRotor.class, rotor -> {
                    rotor.blades = 2;
                });
                this.buildInteriorLayer(world, start, 15, MekanismBlocks.PRESSURE_DISPERSER.defaultState());
                world.setBlockAndUpdate(start.offset(this.sizeX / 2, 15, this.sizeZ / 2), GeneratorsBlocks.ROTATIONAL_COMPLEX.defaultState());
                this.buildInteriorLayer(world, start, 16, GeneratorsBlocks.SATURATING_CONDENSER.defaultState());
                this.buildPlane(world, start, 5, 5, 13, 13, 16, GeneratorsBlocks.ELECTROMAGNETIC_COIL.defaultState());
            }
        }

        protected BlockState getWallBlock(BlockPos pos) {
            return pos.getY() >= 15 ? GeneratorsBlocks.TURBINE_VENT.defaultState() : super.getWallBlock(pos);
        }

        protected BlockState getRoofBlock(BlockPos pos) {
            return GeneratorsBlocks.TURBINE_VENT.defaultState();
        }

        protected BlockState getCasing() {
            return GeneratorsBlocks.TURBINE_CASING.defaultState();
        }
    }
}

