/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.gui;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.DynamicTooltip;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.client.util.RenderHelper;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.network.machines.AdjustSlotCapacityPacket;
import aztech.modern_industrialization.network.machines.LockAllPacket;
import aztech.modern_industrialization.network.machines.SetLockingModePacket;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class MachineScreen
extends MIHandledScreen<MachineMenuClient>
implements ClientComponentRenderer.ButtonContainer {
    public static final ResourceLocation SLOT_ATLAS = MI.id("textures/gui/container/slot_atlas.png");
    public static final ResourceLocation BACKGROUND = MI.id("textures/gui/container/background.png");
    private final List<ClientComponentRenderer> renderers = new ArrayList<ClientComponentRenderer>();
    private int nextButtonX;
    private static final int BUTTON_Y = 4;

    public MachineScreen(MachineMenuClient handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        for (GuiComponentClient<?, ?> component : handler.components) {
            this.renderers.add(component.createRenderer(this));
        }
        this.imageHeight = handler.guiParams.backgroundHeight;
        this.imageWidth = handler.guiParams.backgroundWidth;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public int x() {
        return this.leftPos;
    }

    public int y() {
        return this.topPos;
    }

    private int buttonX() {
        this.nextButtonX -= 22;
        return this.nextButtonX + 22 + this.leftPos;
    }

    private int buttonY() {
        return 4 + this.topPos;
    }

    protected void init() {
        super.init();
        this.nextButtonX = 152;
        if (((MachineMenuClient)this.menu).guiParams.lockButton) {
            this.addLockButton();
        }
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.addButtons(this);
        }
    }

    public void blitButton(Button button, GuiGraphics guiGraphics, int baseU, int baseV, int selectedOverlayU, int selectedOverlayV) {
        guiGraphics.blit(SLOT_ATLAS, button.getX(), button.getY(), baseU, baseV, button.getWidth(), button.getHeight());
        if (button.isHoveredOrFocused()) {
            guiGraphics.blit(SLOT_ATLAS, button.getX(), button.getY(), selectedOverlayU, selectedOverlayV, button.getWidth(), button.getHeight());
        }
    }

    public void blitButton(Button button, GuiGraphics guiGraphics, int u, int v) {
        this.blitButton(button, guiGraphics, u, v, 60, 18);
    }

    public void blitButtonSmall(Button button, GuiGraphics guiGraphics, int u, int v) {
        this.blitButton(button, guiGraphics, u, v, 138, 58);
    }

    public void blitButtonNoHighlight(Button button, GuiGraphics guiGraphics, int u, int v) {
        guiGraphics.blit(SLOT_ATLAS, button.getX(), button.getY(), u, v, button.getWidth(), button.getHeight());
    }

    @Override
    public MachineButton addButton(int u, Consumer<Integer> pressAction, Supplier<List<Component>> tooltipSupplier, Supplier<Boolean> isPressed) {
        return (MachineButton)this.addRenderableWidget((GuiEventListener)new MachineButton(this.buttonX(), this.buttonY(), 20, 20, b -> pressAction.accept(((MachineMenuClient)this.menu).containerId), tooltipSupplier, (screen, button, guiGraphics, mouseX, mouseY, delta) -> this.blitButton(button, guiGraphics, u, (Boolean)isPressed.get() != false ? 38 : 18), () -> true));
    }

    @Override
    public MachineButton addButton(int posX, int posY, int width, int height, Consumer<Integer> pressAction, Supplier<List<Component>> tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer, Supplier<Boolean> isButtonPresent) {
        return (MachineButton)this.addRenderableWidget((GuiEventListener)new MachineButton(posX + this.leftPos, posY + this.topPos, width, height, b -> pressAction.accept(((MachineMenuClient)this.menu).containerId), tooltipSupplier, renderer, isButtonPresent));
    }

    private void addLockButton() {
        this.addButton(40, syncId -> {
            if (MachineScreen.hasShiftDown()) {
                boolean lock = ((MachineMenuClient)this.menu).hasUnlockedSlot();
                ((MachineMenuClient)this.menu).lockAll(lock);
                new LockAllPacket((int)syncId, lock).sendToServer();
            } else {
                boolean newLockingMode;
                ((MachineMenuClient)this.menu).lockingMode = newLockingMode = !((MachineMenuClient)this.menu).lockingMode;
                new SetLockingModePacket((int)syncId, newLockingMode).sendToServer();
            }
        }, () -> {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            if (((MachineMenuClient)this.menu).lockingMode) {
                lines.add(MIText.LockingModeOn.text());
                lines.add(MIText.ClickToDisable.text().setStyle(TextHelper.GRAY_TEXT));
            } else {
                lines.add(MIText.LockingModeOff.text());
                lines.add(MIText.ClickToEnable.text().setStyle(TextHelper.GRAY_TEXT));
            }
            lines.add((((MachineMenuClient)this.menu).hasUnlockedSlot() ? MIText.ShiftClickToLockAll : MIText.ShiftClickToUnlockAll).text().setStyle(TextHelper.GRAY_TEXT));
            return lines;
        }, () -> ((MachineMenuClient)this.menu).lockingMode);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        for (Renderable element : this.renderables) {
            if (!(element instanceof MachineButton)) continue;
            MachineButton machineButton = (MachineButton)element;
            machineButton.visible = machineButton.isPresent.get();
        }
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderConfigurableSlotTooltips(guiGraphics, mouseX, mouseY);
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.renderTooltip(this, this.font, guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
        }
    }

    private FormattedCharSequence titleToRender() {
        int maxWidth = this.nextButtonX + 22 - this.titleLabelX;
        if (this.font.width((FormattedText)this.title) > maxWidth) {
            FormattedText text = FormattedText.composite((FormattedText[])new FormattedText[]{this.font.substrByWidth((FormattedText)this.title, maxWidth - this.font.width("...")), FormattedText.of((String)"...")});
            return Language.getInstance().getVisualOrder(text);
        }
        return this.title.getVisualOrderText();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.titleToRender(), this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int bw = ((MachineMenuClient)this.menu).guiParams.backgroundWidth;
        int bh = ((MachineMenuClient)this.menu).guiParams.backgroundHeight;
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos + 4, 0, 256 - bh + 4, bw, bh - 4);
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, bw, 4);
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.renderBackground(guiGraphics, this.leftPos, this.topPos);
        }
        this.renderConfigurableSlotBackgrounds(guiGraphics);
    }

    private void renderConfigurableSlotBackgrounds(GuiGraphics guiGraphics) {
        for (Slot slot : ((MachineMenuClient)this.menu).slots) {
            BackgroundRenderedSlot brs;
            ResourceLocation atlas;
            if (!(slot instanceof BackgroundRenderedSlot) || (atlas = (brs = (BackgroundRenderedSlot)slot).getBackgroundAtlasLocation()) == null) continue;
            int px = this.leftPos + slot.x - 1;
            int py = this.topPos + slot.y - 1;
            guiGraphics.blit(atlas, px, py, brs.getBackgroundU(), brs.getBackgroundV(), 18, 18);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        Item item;
        ConfigurableItemStack.ConfigurableItemSlot itemSlot;
        ConfigurableItemStack itemStack;
        if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
            FluidVariant renderedKey;
            ConfigurableFluidStack.ConfigurableFluidSlot cfs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
            ConfigurableFluidStack stack = cfs.getConfStack();
            FluidVariant fluidVariant = renderedKey = stack.getLockedInstance() == null ? (FluidVariant)stack.getResource() : FluidVariant.of((Fluid)stack.getLockedInstance());
            if (!renderedKey.isBlank()) {
                RenderHelper.drawFluidInGui(guiGraphics, renderedKey, slot.x, slot.y);
            }
            return;
        }
        if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot && ((itemStack = (itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).isPlayerLocked() || itemStack.isMachineLocked()) && ((ItemVariant)itemStack.getResource()).isBlank() && (item = (Item)itemStack.getLockedInstance()) != Items.AIR) {
            RenderHelper.renderAndDecorateItem(guiGraphics, this.font, new ItemStack((ItemLike)item), slot.x, slot.y, "0");
        }
        super.renderSlot(guiGraphics, slot);
    }

    private void renderConfigurableSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
            ConfigurableFluidStack stack = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
            FluidVariant renderedKey = stack.getLockedInstance() != null ? FluidVariant.of((Fluid)stack.getLockedInstance()) : (FluidVariant)stack.getResource();
            ArrayList<Component> tooltip = new ArrayList<Component>(FluidHelper.getTooltipForFluidStorage(renderedKey, stack.getAmount(), stack.getCapacity(), false));
            if (stack.canPlayerInsert()) {
                if (stack.canPlayerExtract()) {
                    tooltip.add((Component)MIText.FluidSlotIO.text().setStyle(TextHelper.GRAY_TEXT));
                } else {
                    tooltip.add((Component)MIText.FluidSlotInput.text().setStyle(TextHelper.GRAY_TEXT));
                }
            } else if (stack.canPlayerExtract()) {
                tooltip.add((Component)MIText.FluidSlotOutput.text().setStyle(TextHelper.GRAY_TEXT));
            }
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
            ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
            this.renderConfigurableItemStackTooltip(guiGraphics, confSlot.getConfStack(), mouseX, mouseY);
        } else if (slot != null && slot.hasItem()) {
            guiGraphics.renderTooltip(this.font, slot.getItem(), mouseX, mouseY);
        }
    }

    private void renderConfigurableItemStackTooltip(GuiGraphics guiGraphics, ConfigurableItemStack stack, int mouseX, int mouseY) {
        List<MutableComponent> textTooltip;
        ItemStack vanillaStack;
        ItemStack itemStack = stack.isEmpty() ? (stack.getLockedInstance() == null ? ItemStack.EMPTY : new ItemStack((ItemLike)stack.getLockedInstance())) : (vanillaStack = ((ItemVariant)stack.getResource()).toStack((int)stack.getAmount()));
        if (vanillaStack.isEmpty()) {
            textTooltip = new ArrayList();
            textTooltip.add(MIText.Empty.text());
        } else {
            textTooltip = MachineScreen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)vanillaStack);
        }
        Optional data = vanillaStack.getTooltipImage();
        MutableComponent capacityText = Component.literal((String)String.valueOf(stack.getAdjustedCapacity()));
        if (stack.getAdjustedCapacity() != 64) {
            capacityText.setStyle(TextHelper.YELLOW_BOLD);
        }
        textTooltip.add(MIText.ConfigurableSlotCapacity.text(capacityText).setStyle(TextHelper.GRAY_TEXT));
        guiGraphics.renderTooltip(this.font, textTooltip, data, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
            ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
            ConfigurableItemStack stack = confSlot.getConfStack();
            boolean isIncrease = amountY > 0.0;
            boolean isShiftDown = MachineScreen.hasShiftDown();
            stack.adjustCapacity(isIncrease, isShiftDown);
            new AdjustSlotCapacityPacket(((MachineMenuClient)this.menu).containerId, ((MachineMenuClient)this.menu).slots.indexOf((Object)this.hoveredSlot), isIncrease, isShiftDown).sendToServer();
            return true;
        }
        return false;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return this.getExtraBoxes().stream().noneMatch(r -> r.contains(mouseX, mouseY)) && super.hasClickedOutside(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    public MachineGuiParameters getGuiParams() {
        return ((MachineMenuClient)this.menu).getGuiParams();
    }

    @Override
    public Slot getFocusedSlot() {
        return this.hoveredSlot;
    }

    public List<Rectangle> getExtraBoxes() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.addExtraBoxes(list, this.leftPos, this.topPos);
        }
        return list;
    }

    public class MachineButton
    extends Button {
        private final Supplier<List<Component>> tooltipSupplier;
        final ClientComponentRenderer.CustomButtonRenderer renderer;
        final Supplier<Boolean> isPresent;

        private MachineButton(int x, int y, int width, int height, Button.OnPress onPress, Supplier<List<Component>> tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer, Supplier<Boolean> isPresent) {
            super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.tooltipSupplier = tooltipSupplier;
            this.setTooltip(new DynamicTooltip(tooltipSupplier));
            this.renderer = renderer;
            this.isPresent = isPresent;
        }

        public Component getMessage() {
            List<Component> tooltip = this.tooltipSupplier.get();
            return tooltip.isEmpty() ? Component.empty() : tooltip.getFirst();
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.visible = this.isPresent.get();
            super.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderer.renderButton(MachineScreen.this, this, guiGraphics, mouseX, mouseY, partialTick);
        }

        public void renderVanilla(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            super.renderWidget(guiGraphics, mouseX, mouseY, delta);
        }
    }
}

