/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.util.RenderHelper;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RecipeEfficiencyBarClient
extends GuiComponentClient<RecipeEfficiencyBar.Params, RecipeEfficiencyBar.Data> {
    private static final ResourceLocation TEXTURE = MI.id("textures/gui/efficiency_bar.png");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 2;

    public RecipeEfficiencyBarClient(RecipeEfficiencyBar.Params params, RecipeEfficiencyBar.Data data) {
        super(params, data);
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(TEXTURE, x + ((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderX() - 1, y + ((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderY() - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            if (((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).hasActiveRecipe()) {
                int barPixels = (int)((float)((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).efficiencyTicks() / (float)((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).maxEfficiencyTicks() * 100.0f);
                guiGraphics.blit(TEXTURE, x + ((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderX(), y + ((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderY(), 0.0f, 0.0f, barPixels, 2, 102, 6);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderX(), ((RecipeEfficiencyBar.Params)RecipeEfficiencyBarClient.this.params).renderY(), 100, 2, cursorX - x, cursorY - y)) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).hasActiveRecipe()) {
                    DecimalFormat factorFormat = new DecimalFormat("#.#");
                    tooltip.add(MIText.EfficiencyTicks.text(((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).efficiencyTicks(), ((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).maxEfficiencyTicks()));
                    tooltip.add(MIText.EfficiencyFactor.text(factorFormat.format((double)((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).currentRecipeEu() / (double)((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).baseRecipeEu())));
                    tooltip.add(MIText.EfficiencyEu.text(((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).currentRecipeEu()));
                } else {
                    tooltip.add(MIText.EfficiencyDefaultMessage.text());
                }
                tooltip.add(MIText.EfficiencyMaxOverclock.text(((RecipeEfficiencyBar.Data)RecipeEfficiencyBarClient.this.data).maxRecipeEu()));
                guiGraphics.renderTooltip(font, tooltip, Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

