/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.machine;

import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ExtraMachineConfig {
    private static List<OverclockComponent.Catalyst> parseOverclockFromObject(JsonObject object) {
        ArrayList<OverclockComponent.Catalyst> catalysts = new ArrayList<OverclockComponent.Catalyst>();
        for (Map.Entry entry : object.entrySet()) {
            String catalystName = (String)entry.getKey();
            JsonObject parameters = ((JsonElement)entry.getValue()).getAsJsonObject();
            double multiplier = GsonHelper.getAsDouble((JsonObject)parameters, (String)"multiplier");
            int ticks = GsonHelper.getAsInt((JsonObject)parameters, (String)"ticks");
            catalysts.add(new OverclockComponent.Catalyst(multiplier, ResourceLocation.parse((String)catalystName), ticks));
        }
        return catalysts;
    }

    public static class CraftingMultiBlock {
        public List<OverclockComponent.Catalyst> steamOverclockCatalysts = OverclockComponent.getDefaultCatalysts();
        public List<Consumer<MultiblockMachines.Rei>> reiConfigs = new ArrayList<Consumer<MultiblockMachines.Rei>>();

        public CraftingMultiBlock steamCustomOverclock(JsonObject object) {
            this.steamOverclockCatalysts = ExtraMachineConfig.parseOverclockFromObject(object);
            return this;
        }

        public CraftingMultiBlock reiExtra(Consumer<MultiblockMachines.Rei> consumer) {
            this.reiConfigs.add(consumer);
            return this;
        }
    }

    public static class CraftingSingleBlock {
        private final SingleBlockCraftingMachines.Config config;

        public CraftingSingleBlock(SingleBlockCraftingMachines.Config config) {
            this.config = config;
        }

        public CraftingSingleBlock steamCustomOverclock(JsonObject object) {
            this.config.steamOverclockCatalysts = ExtraMachineConfig.parseOverclockFromObject(object);
            return this;
        }
    }
}

