/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.machine;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.kubejs.machine.ExtraMachineConfig;
import aztech.modern_industrialization.compat.kubejs.machine.ShapeTemplateHelper;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.GeneratorMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.GeneratorMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.SteamCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.FluidItemConsumerComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;

public class RegisterMachinesEventJS
implements KubeEvent,
ShapeTemplateHelper {
    public ProgressBar.Params progressBar(int renderX, int renderY, String type) {
        return new ProgressBar.Params(renderX, renderY, type);
    }

    public ProgressBar.Params progressBar(int renderX, int renderY, String type, int width, int height) {
        return new ProgressBar.Params(renderX, renderY, type, width, height, false);
    }

    public RecipeEfficiencyBar.Params efficiencyBar(int renderX, int renderY) {
        return new RecipeEfficiencyBar.Params(renderX, renderY);
    }

    public EnergyBar.Params energyBar(int renderX, int renderY) {
        return new EnergyBar.Params(renderX, renderY);
    }

    public void craftingSingleBlock(String englishName, String internalName, MachineRecipeType recipeType, List<String> tiers, int backgroundHeight, ProgressBar.Params progressBar, RecipeEfficiencyBar.Params efficiencyBar, EnergyBar.Params energyBar, int itemInputs, int itemOutputs, int fluidInputs, int fluidOutputs, int bucketCapacity, Consumer<SlotPositions.Builder> itemSlotPositions, Consumer<SlotPositions.Builder> fluidSlotPositions, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        this.craftingSingleBlock(englishName, internalName, recipeType, tiers, backgroundHeight, progressBar, efficiencyBar, energyBar, itemInputs, itemOutputs, fluidInputs, fluidOutputs, bucketCapacity, itemSlotPositions, fluidSlotPositions, frontOverlay, topOverlay, sideOverlay, config -> {});
    }

    public void craftingSingleBlock(String englishName, String internalName, MachineRecipeType recipeType, List<String> tiers, int backgroundHeight, ProgressBar.Params progressBar, RecipeEfficiencyBar.Params efficiencyBar, EnergyBar.Params energyBar, int itemInputs, int itemOutputs, int fluidInputs, int fluidOutputs, int bucketCapacity, Consumer<SlotPositions.Builder> itemSlotPositions, Consumer<SlotPositions.Builder> fluidSlotPositions, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, Consumer<ExtraMachineConfig.CraftingSingleBlock> extraConfig) {
        SingleBlockCraftingMachines.Config config = new SingleBlockCraftingMachines.Config();
        extraConfig.accept(new ExtraMachineConfig.CraftingSingleBlock(config));
        int tiersMask = 0;
        Iterator<String> iterator = tiers.iterator();
        while (iterator.hasNext()) {
            String tier;
            tiersMask |= (switch (tier = iterator.next()) {
                case "bronze" -> 1;
                case "steel" -> 2;
                case "electric" -> 4;
                default -> throw new IllegalArgumentException("Unknown tier: " + tier);
            });
        }
        Consumer<MachineGuiParameters.Builder> guiParams = backgroundHeight < 0 ? p -> {} : p -> p.backgroundHeight(backgroundHeight);
        SingleBlockCraftingMachines.registerMachineTiers(englishName, internalName, recipeType, itemInputs, itemOutputs, fluidInputs, fluidOutputs, guiParams, progressBar, efficiencyBar, energyBar, itemSlotPositions, fluidSlotPositions, frontOverlay, topOverlay, sideOverlay, tiersMask, bucketCapacity, config);
    }

    private void simpleMultiBlock(String englishName, String internalName, ShapeTemplate multiblockShape, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, Function<BEP, MachineBlockEntity> factory) {
        MachineCasing controllerCasing = MachineCasings.get(controllerCasingName);
        MachineRegistrationHelper.registerMachine(englishName, internalName, factory, new Consumer[0]);
        MachineRegistrationHelper.addMachineModel(internalName, overlayFolder, controllerCasing, frontOverlay, topOverlay, sideOverlay);
        ReiMachineRecipes.registerMultiblockShape(internalName, multiblockShape);
    }

    public void simpleElectricCraftingMultiBlock(String englishName, String internalName, MachineRecipeType recipeType, ShapeTemplate multiblockShape, ProgressBar.Params progressBar, Consumer<SlotPositions.Builder> itemInputPositions, Consumer<SlotPositions.Builder> itemOutputPositions, Consumer<SlotPositions.Builder> fluidInputPositions, Consumer<SlotPositions.Builder> fluidOutputPositions, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        this.simpleElectricCraftingMultiBlock(englishName, internalName, recipeType, multiblockShape, progressBar, itemInputPositions, itemOutputPositions, fluidInputPositions, fluidOutputPositions, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, config -> {});
    }

    public void simpleElectricCraftingMultiBlock(String englishName, String internalName, MachineRecipeType recipeType, ShapeTemplate multiblockShape, ProgressBar.Params progressBar, Consumer<SlotPositions.Builder> itemInputPositions, Consumer<SlotPositions.Builder> itemOutputPositions, Consumer<SlotPositions.Builder> fluidInputPositions, Consumer<SlotPositions.Builder> fluidOutputPositions, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, Consumer<ExtraMachineConfig.CraftingMultiBlock> extraConfig) {
        ExtraMachineConfig.CraftingMultiBlock config = new ExtraMachineConfig.CraftingMultiBlock();
        extraConfig.accept(config);
        this.simpleCraftingMultiBlock(englishName, internalName, recipeType, multiblockShape, progressBar, itemInputPositions, itemOutputPositions, fluidInputPositions, fluidOutputPositions, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, bep -> new ElectricCraftingMultiblockBlockEntity((BEP)bep, internalName, multiblockShape, recipeType), config.reiConfigs);
    }

    public void simpleSteamCraftingMultiBlock(String englishName, String internalName, MachineRecipeType recipeType, ShapeTemplate multiblockShape, ProgressBar.Params progressBar, Consumer<SlotPositions.Builder> itemInputPositions, Consumer<SlotPositions.Builder> itemOutputPositions, Consumer<SlotPositions.Builder> fluidInputPositions, Consumer<SlotPositions.Builder> fluidOutputPositions, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        this.simpleSteamCraftingMultiBlock(englishName, internalName, recipeType, multiblockShape, progressBar, itemInputPositions, itemOutputPositions, fluidInputPositions, fluidOutputPositions, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, config -> {});
    }

    public void simpleSteamCraftingMultiBlock(String englishName, String internalName, MachineRecipeType recipeType, ShapeTemplate multiblockShape, ProgressBar.Params progressBar, Consumer<SlotPositions.Builder> itemInputPositions, Consumer<SlotPositions.Builder> itemOutputPositions, Consumer<SlotPositions.Builder> fluidInputPositions, Consumer<SlotPositions.Builder> fluidOutputPositions, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, Consumer<ExtraMachineConfig.CraftingMultiBlock> extraConfig) {
        ExtraMachineConfig.CraftingMultiBlock config = new ExtraMachineConfig.CraftingMultiBlock();
        config.reiConfigs.add(rei -> rei.steam(true));
        extraConfig.accept(config);
        this.simpleCraftingMultiBlock(englishName, internalName, recipeType, multiblockShape, progressBar, itemInputPositions, itemOutputPositions, fluidInputPositions, fluidOutputPositions, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, bep -> new SteamCraftingMultiblockBlockEntity((BEP)bep, internalName, multiblockShape, recipeType, config.steamOverclockCatalysts), config.reiConfigs);
    }

    private void simpleCraftingMultiBlock(String englishName, String internalName, MachineRecipeType recipeType, ShapeTemplate multiblockShape, ProgressBar.Params progressBar, Consumer<SlotPositions.Builder> itemInputPositions, Consumer<SlotPositions.Builder> itemOutputPositions, Consumer<SlotPositions.Builder> fluidInputPositions, Consumer<SlotPositions.Builder> fluidOutputPositions, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, Function<BEP, MachineBlockEntity> factory, List<Consumer<MultiblockMachines.Rei>> reiConfigs) {
        this.simpleMultiBlock(englishName, internalName, multiblockShape, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, factory);
        MultiblockMachines.Rei rei = new MultiblockMachines.Rei(englishName, internalName, recipeType, progressBar).items(itemInputPositions, itemOutputPositions).fluids(fluidInputPositions, fluidOutputPositions);
        for (Consumer<MultiblockMachines.Rei> reiConfig : reiConfigs) {
            reiConfig.accept(rei);
        }
        rei.register();
    }

    public void simpleGeneratorSingleBlock(String englishName, String internalName, String cableTierName, long maxEnergyProduction, long energyCapacity, long fluidStorageCapacity, Consumer<FluidItemConsumerBuilder> builder, String casingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        FluidItemConsumerBuilder componentBuilder = new FluidItemConsumerBuilder(maxEnergyProduction);
        builder.accept(componentBuilder);
        MachineRegistrationHelper.registerMachine(englishName, internalName, bep -> new GeneratorMachineBlockEntity((BEP)bep, internalName, true, CableTier.getTier(cableTierName), energyCapacity, fluidStorageCapacity, componentBuilder.build()), MachineBlockEntity::registerItemApi, MachineBlockEntity::registerFluidApi, GeneratorMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.addMachineModel(internalName, overlayFolder, MachineCasings.get(casingName), frontOverlay, topOverlay, sideOverlay);
    }

    public void simpleGeneratorSingleBlock(String englishName, String internalName, String cableTierName, long maxEnergyProduction, long energyCapacity, Consumer<FluidItemConsumerBuilder> builder, String casingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        this.simpleGeneratorSingleBlock(englishName, internalName, cableTierName, maxEnergyProduction, energyCapacity, 0L, builder, casingName, overlayFolder, frontOverlay, topOverlay, sideOverlay);
    }

    public void simpleGeneratorMultiBlock(String englishName, String internalName, ShapeTemplate multiblockShape, long maxEnergyProduction, Consumer<FluidItemConsumerBuilder> builder, String controllerCasingName, String overlayFolder, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        FluidItemConsumerBuilder componentBuilder = new FluidItemConsumerBuilder(maxEnergyProduction);
        builder.accept(componentBuilder);
        Function<BEP, MachineBlockEntity> ctor = bep -> new GeneratorMultiblockBlockEntity((BEP)bep, internalName, multiblockShape, componentBuilder.build());
        this.simpleMultiBlock(englishName, internalName, multiblockShape, controllerCasingName, overlayFolder, frontOverlay, topOverlay, sideOverlay, ctor);
    }

    public static class FluidItemConsumerBuilder {
        long maxEnergyProduction;
        FluidItemConsumerComponent.EuProductionMapBuilder<Item> itemEuProductionMapBuilder = new FluidItemConsumerComponent.EuProductionMapBuilder(BuiltInRegistries.ITEM);
        FluidItemConsumerComponent.EuProductionMapBuilder<Fluid> fluidEuProductionMapBuilder = new FluidItemConsumerComponent.EuProductionMapBuilder(BuiltInRegistries.FLUID);
        boolean doesAcceptAllFluidFuels = false;
        boolean doesAcceptAllItemFuels = false;

        public FluidItemConsumerBuilder(long maxEnergyProduction) {
            this.maxEnergyProduction = maxEnergyProduction;
        }

        public FluidItemConsumerBuilder fluidFuels() {
            this.doesAcceptAllFluidFuels = true;
            return this;
        }

        public FluidItemConsumerBuilder furnaceFuels() {
            this.doesAcceptAllItemFuels = true;
            return this;
        }

        public FluidItemConsumerBuilder fluid(ResourceLocation fluidId, long euPerMb) {
            this.fluidEuProductionMapBuilder.add(fluidId, euPerMb);
            return this;
        }

        public FluidItemConsumerBuilder item(ResourceLocation itemId, long euPerItem) {
            this.itemEuProductionMapBuilder.add(itemId, euPerItem);
            return this;
        }

        public FluidItemConsumerComponent build() {
            return new FluidItemConsumerComponent(this.maxEnergyProduction, this.doesAcceptAllItemFuels ? FluidItemConsumerComponent.itemFuels() : this.itemEuProductionMapBuilder.build(), this.doesAcceptAllFluidFuels ? FluidItemConsumerComponent.fluidFuels() : this.fluidEuProductionMapBuilder.build());
        }
    }
}

