/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.kubejs.recipe.MachineRecipeSchema;
import aztech.modern_industrialization.compat.kubejs.recipe.ProcessConditionHelper;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import com.mojang.logging.LogUtils;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.slf4j.Logger;

public class MachineKubeRecipe
extends KubeRecipe
implements ProcessConditionHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final KubeRecipeFactory FACTORY = new KubeRecipeFactory(MI.id("machine"), MachineKubeRecipe.class, MachineKubeRecipe::new);

    private <T> MachineKubeRecipe addToList(RecipeKey<List<T>> key, T element) {
        List value = (List)this.getValue(key);
        ArrayList<T> list = value == null ? new ArrayList<T>() : new ArrayList(value);
        list.add(element);
        this.setValue(key, list);
        return this;
    }

    public MachineKubeRecipe itemIn(SizedIngredient ingredient) {
        return this.itemIn(ingredient, 1.0f);
    }

    public MachineKubeRecipe itemIn(SizedIngredient ingredient, float chance) {
        return this.addToList(MachineRecipeSchema.ITEM_INPUTS, new MachineRecipe.ItemInput(ingredient.ingredient(), ingredient.count(), chance));
    }

    public MachineKubeRecipe itemOut(ItemStack output) {
        return this.itemOut(output, 1.0f);
    }

    public MachineKubeRecipe itemOut(ItemStack output, float chance) {
        return this.addToList(MachineRecipeSchema.ITEM_OUTPUTS, new MachineRecipe.ItemOutput(ItemVariant.of(output), output.getCount(), chance));
    }

    public MachineKubeRecipe fluidIn(SizedFluidIngredient ingredient) {
        return this.fluidInInternal(ingredient, 1.0f);
    }

    public MachineKubeRecipe fluidIn(SizedFluidIngredient ingredient, float chance) {
        if ((ingredient.amount() == 1 || ingredient.amount() == 1000) && chance > 1.0f) {
            LOGGER.warn("fluidIn with separate fluid and amount is deprecated. Use fluidIn(\"%dx %s\") notation instead.".formatted((int)chance, BuiltInRegistries.FLUID.getKey((Object)ingredient.ingredient().getStacks()[0].getFluid())));
            return this.fluidIn(new SizedFluidIngredient(ingredient.ingredient(), (int)chance));
        }
        if (ingredient.amount() == 1000 && chance == 1.0f) {
            throw new IllegalArgumentException("fluidIn(\"some_fluid\", 1) is ambiguous. Use either fluidIn(\"1x some_fluid\") or fluidIn(\"some_fluid\") depending on what you meant.");
        }
        return this.fluidInInternal(ingredient, chance);
    }

    private MachineKubeRecipe fluidInInternal(SizedFluidIngredient ingredient, float chance) {
        if (chance > 1.0f) {
            throw new IllegalArgumentException("Fluid input chance must be between 0 and 1. It is " + chance);
        }
        return this.addToList(MachineRecipeSchema.FLUID_INPUTS, new MachineRecipe.FluidInput(ingredient.ingredient(), (long)ingredient.amount(), chance));
    }

    public MachineKubeRecipe fluidOut(FluidStack output) {
        return this.fluidOutInternal(output, 1.0f);
    }

    public MachineKubeRecipe fluidOut(FluidStack output, float chance) {
        if ((output.getAmount() == 1 || output.getAmount() == 1000) && chance > 1.0f) {
            LOGGER.warn("fluidOut with separate fluid and amount is deprecated. Use fluidOut(\"%dx %s\") notation instead.".formatted((int)chance, BuiltInRegistries.FLUID.getKey((Object)output.getFluid())));
            return this.fluidOut(output.copyWithAmount((int)chance));
        }
        if (output.getAmount() == 1000 && chance == 1.0f) {
            throw new IllegalArgumentException("fluidOut(\"some_fluid\", 1) is ambiguous. Use either fluidOut(\"1x some_fluid\") or fluidOut(\"some_fluid\") depending on what you meant.");
        }
        return this.fluidOutInternal(output, chance);
    }

    private MachineKubeRecipe fluidOutInternal(FluidStack output, float chance) {
        if (!output.isComponentsPatchEmpty()) {
            throw new IllegalArgumentException("FluidStack components are not supported in machine recipe outputs.");
        }
        return this.addToList(MachineRecipeSchema.FLUID_OUTPUTS, new MachineRecipe.FluidOutput(output.getFluid(), output.getAmount(), chance));
    }

    @Deprecated(forRemoval=true)
    public MachineKubeRecipe fluidIn(FluidIngredient fluid, long mbs, float probability) {
        LOGGER.warn("fluidIn with separate fluid and amount is deprecated. Use fluidIn(\"%dx %s\", %f) notation instead.".formatted(mbs, BuiltInRegistries.FLUID.getKey((Object)fluid.getStacks()[0].getFluid()), Float.valueOf(probability)));
        return this.fluidIn(new SizedFluidIngredient(fluid, (int)mbs), probability);
    }

    @Deprecated(forRemoval=true)
    public MachineKubeRecipe fluidOut(Fluid fluid, long mbs, float probability) {
        LOGGER.warn("fluidOut with separate fluid and amount is deprecated. Use fluidOut(\"%dx %s\", %f) notation instead.".formatted(mbs, BuiltInRegistries.FLUID.getKey((Object)fluid), Float.valueOf(probability)));
        return this.addToList(MachineRecipeSchema.FLUID_OUTPUTS, new MachineRecipe.FluidOutput(fluid, mbs, probability));
    }

    @Override
    public MachineKubeRecipe processCondition(MachineProcessCondition condition) {
        return this.addToList(MachineRecipeSchema.MACHINE_PROCESS_CONDITIONS, condition);
    }
}

