/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.datamap;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.api.datamaps.ItemPipeUpgrade;
import aztech.modern_industrialization.api.datamaps.ItemTooltip;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.api.datamaps.MachineUpgrade;
import aztech.modern_industrialization.datagen.loot.MILootTables;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.RaidHeroGift;

public class MIDataMapProvider
extends DataMapProvider {
    public MIDataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather(HolderLookup.Provider registries) {
        this.gatherFurnaceFuels();
        this.gatherFluidFuels();
        this.gatherItemPipeUpgrades();
        this.gatherMachineUpgrades();
        this.gatherItemTooltips();
        this.builder(NeoForgeDataMaps.RAID_HERO_GIFTS).add(MIRegistries.INDUSTRIALIST, (Object)new RaidHeroGift(MILootTables.INDUSTRIALIST_GIFT), false, new ICondition[0]);
    }

    private void gatherFurnaceFuels() {
        this.addFuel("coke", 6400);
        this.addFuel("coke_dust", 6400);
        this.addFuel("coke_block", 57600);
        this.addFuel("coal_crushed_dust", 1600);
        this.builder(NeoForgeDataMaps.FURNACE_FUELS).add(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:dusts/coal")), (Object)new FurnaceFuel(1600), false, new ICondition[0]);
        this.addFuel("coal_tiny_dust", 160);
        this.addFuel("lignite_coal", 1600);
        this.addFuel("lignite_coal_block", 16000);
        this.addFuel("lignite_coal_crushed_dust", 1600);
        this.addFuel("lignite_coal_dust", 1600);
        this.addFuel("lignite_coal_tiny_dust", 160);
        this.addFuel("carbon_dust", 6400);
        this.addFuel("carbon_tiny_dust", 640);
        this.addFuel(MIItem.GUIDE_BOOK.path(), 300);
    }

    private void addFuel(String path, int value) {
        this.builder(NeoForgeDataMaps.FURNACE_FUELS).add(MI.id(path), (Object)new FurnaceFuel(value), false, new ICondition[0]);
    }

    private void gatherFluidFuels() {
        this.addFluidFuel(MIFluids.HYDROGEN, 1);
        this.addFluidFuel(MIFluids.DEUTERIUM, 1);
        this.addFluidFuel(MIFluids.TRITIUM, 1);
        this.addFluidFuel(MIFluids.CRUDE_OIL, 16);
        this.addFluidFuel(MIFluids.SYNTHETIC_OIL, 16);
        this.addFluidFuel(MIFluids.RAW_BIODIESEL, 50);
        this.addFluidFuel(MIFluids.NAPHTHA, 80);
        this.addFluidFuel(MIFluids.CREOSOTE, 160);
        this.addFluidFuel(MIFluids.LIGHT_FUEL, 160);
        this.addFluidFuel(MIFluids.HEAVY_FUEL, 240);
        this.addFluidFuel(MIFluids.BIODIESEL, 250);
        this.addFluidFuel(MIFluids.DIESEL, 400);
        this.addFluidFuel(MIFluids.BOOSTED_DIESEL, 800);
    }

    private void addFluidFuel(FluidDefinition fluidDefinition, int euPerMb) {
        this.builder(MIDataMaps.FLUID_FUELS).add(fluidDefinition.getId(), (Object)new FluidFuel(euPerMb), false, new ICondition[0]);
    }

    private void gatherItemPipeUpgrades() {
        this.addItemPipeUpgrade(MIItem.MOTOR, 2);
        this.addItemPipeUpgrade(MIItem.LARGE_MOTOR, 16);
        this.addItemPipeUpgrade(MIItem.ADVANCED_MOTOR, 64);
        this.addItemPipeUpgrade(MIItem.LARGE_ADVANCED_MOTOR, 512);
    }

    private void addItemPipeUpgrade(ItemDefinition<?> itemDefinition, int maxExtractedItems) {
        this.builder(MIDataMaps.ITEM_PIPE_UPGRADES).add(itemDefinition.getId(), (Object)new ItemPipeUpgrade(maxExtractedItems), false, new ICondition[0]);
    }

    private void gatherMachineUpgrades() {
        this.addMachineUpgrade(MIItem.BASIC_UPGRADE, 2);
        this.addMachineUpgrade(MIItem.ADVANCED_UPGRADE, 16);
        this.addMachineUpgrade(MIItem.TURBO_UPGRADE, 64);
        this.addMachineUpgrade(MIItem.HIGHLY_ADVANCED_UPGRADE, 512);
        this.addMachineUpgrade(MIItem.QUANTUM_UPGRADE, 999999999);
    }

    private void addMachineUpgrade(ItemDefinition<?> itemDefinition, int extraMaxEu) {
        this.builder(MIDataMaps.MACHINE_UPGRADES).add(itemDefinition.getId(), (Object)new MachineUpgrade(extraMaxEu), false, new ICondition[0]);
    }

    private void gatherItemTooltips() {
        this.addItemTooltip("capacitor", MIText.HasBetterYieldAssemblerRecipe);
        this.addItemTooltip("inductor", MIText.HasBetterYieldAssemblerRecipe);
        this.addItemTooltip("resistor", MIText.HasBetterYieldAssemblerRecipe);
        for (Material material : MaterialRegistry.getMaterials().values()) {
            MaterialItemPart part = material.getNullablePart(MIParts.GEAR);
            if (part == null) continue;
            this.addItemTooltip(part.getItemId().split(":")[1], MIText.HasBetterYieldAssemblerRecipe);
        }
    }

    private void addItemTooltip(String path, MIText text) {
        MutableComponent component = text.text().setStyle(MITooltips.DEFAULT_STYLE);
        this.builder(MIDataMaps.ITEM_TOOLTIPS).add(MI.id(path), (Object)new ItemTooltip(List.of(component)), false, new ICondition[0]);
    }
}

