/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.machine.holder.FluidStorageComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.FluidStorageComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jspecify.annotations.Nullable;

public class LargeTankHatch
extends HatchBlockEntity
implements FluidStorageComponentHolder {
    private final MIInventory inventory = new MIInventory(List.of(), List.of(), SlotPositions.empty(), SlotPositions.empty());
    private @Nullable LargeTankMultiblockBlockEntity controller = null;

    public LargeTankHatch(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("large_tank_hatch", false).build(), OrientationComponent.Params.noFacingNoOutput());
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void openMenu(ServerPlayer player) {
        if (this.controller != null) {
            this.controller.openMenu(player);
        } else {
            player.displayClientMessage((Component)MIText.NoLargeTank.text().withStyle(ChatFormatting.RED), true);
        }
    }

    @Override
    public HatchType getHatchType() {
        return HatchTypes.LARGE_TANK;
    }

    @Override
    public boolean upgradesToSteel() {
        return false;
    }

    @Override
    public void unlink() {
        super.unlink();
        this.controller = null;
        this.setChanged();
        this.invalidateCapabilities();
    }

    @Override
    public @Nullable FluidStorageComponent getFluidStorageComponent() {
        return this.controller == null ? null : this.controller.getFluidStorageComponent();
    }

    public void setController(LargeTankMultiblockBlockEntity controller) {
        this.controller = controller;
        this.setChanged();
        this.invalidateCapabilities();
    }

    private IFluidHandler getStorage() {
        return this.controller == null ? EmptyFluidHandler.INSTANCE : this.controller.getExposedFluidHandler();
    }

    public static void registerFluidApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> ((LargeTankHatch)be).getStorage()));
    }

    @Override
    protected boolean hasComparatorOutput() {
        return true;
    }

    @Override
    protected int getComparatorOutput() {
        if (this.controller != null) {
            return this.controller.getComparatorOutput();
        }
        return 0;
    }
}

