/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jspecify.annotations.Nullable;

public abstract class AbstractElectricCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity
implements EnergyListComponentHolder,
CrafterComponent.Behavior {
    protected final RedstoneControlComponent redstoneControl;
    protected final List<EnergyComponent> energyInputs = new ArrayList<EnergyComponent>();

    public AbstractElectricCraftingMultiblockBlockEntity(BEP bep, ResourceLocation blockId, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        super(bep, blockId, orientationParams, shapeTemplates);
        this.redstoneControl = new RedstoneControlComponent();
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new CraftingMultiblockGui(() -> this.shapeValid.shapeValid, this.crafter::getProgress, this.crafter, () -> 0);
        this.registerGuiComponent(guiComponentServerArray);
        this.registerComponents(this.redstoneControl);
    }

    public AbstractElectricCraftingMultiblockBlockEntity(BEP bep, String name, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        this(bep, MI.id(name), orientationParams, shapeTemplates);
    }

    public List<EnergyComponent> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            this.energyInputs.clear();
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                hatch.appendEnergyInputs(this.energyInputs);
            }
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.components.mapOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse(this, player, hand), result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse(this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.components.mapOrDefault(OverdriveComponent.class, overdrive -> overdrive.onUse(this, player, hand), result);
        }
        return result;
    }

    @Override
    protected final CrafterComponent.Behavior getBehavior() {
        return this;
    }

    @Override
    public final boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation(this);
    }

    @Override
    public final long consumeEu(long max, Simulation simulation) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, simulation);
        }
        return total;
    }

    @Override
    public final ServerLevel getCrafterWorld() {
        return (ServerLevel)this.level;
    }

    @Override
    public final @Nullable UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }
}

