/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.gui;

import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.ConfigurableScreenHandler;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.ComponentStorage;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public abstract class MachineMenuCommon
extends ConfigurableScreenHandler
implements GuiComponent.MenuFacade {
    public final MachineGuiParameters guiParams;

    protected MachineMenuCommon(int syncId, Inventory playerInventory, MIInventory inventory, MachineGuiParameters guiParams, ComponentStorage<? extends GuiComponent> guiComponents) {
        super(MIRegistries.MACHINE_MENU.get(), syncId, playerInventory, inventory);
        int i;
        this.guiParams = guiParams;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, i2 * 9 + j + 9, guiParams.playerInventoryX + j * 18, guiParams.playerInventoryY + i2 * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, guiParams.playerInventoryX + j * 18, guiParams.playerInventoryY + 58));
        }
        for (GuiComponent guiComponent : guiComponents) {
            guiComponent.setupMenu(this);
        }
        for (i = 0; i < inventory.getItemStacks().size(); ++i) {
            ConfigurableItemStack configurableItemStack = inventory.getItemStacks().get(i);
            this.addSlot(configurableItemStack.new ConfigurableItemStack.ConfigurableItemSlot(() -> {}, inventory.itemPositions.getX(i), inventory.itemPositions.getY(i), s -> true), SlotGroup.CONFIGURABLE_STACKS);
        }
        for (i = 0; i < inventory.getFluidStacks().size(); ++i) {
            ConfigurableFluidStack configurableFluidStack = inventory.getFluidStacks().get(i);
            this.addSlot(configurableFluidStack.new ConfigurableFluidStack.ConfigurableFluidSlot(() -> {}, inventory.fluidPositions.getX(i), inventory.fluidPositions.getY(i)), SlotGroup.CONFIGURABLE_STACKS);
        }
    }

    @Override
    public void addSlotToMenu(Slot slot, SlotGroup slotGroup) {
        this.addSlot(slot, slotGroup);
    }

    @Override
    public MachineGuiParameters getGuiParams() {
        return this.guiParams;
    }

    public abstract void readClientComponentSyncData(int var1, RegistryFriendlyByteBuf var2);
}

