/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.util.Rectangle;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ProgressBar
implements GuiComponentServer<Params, Float> {
    public static final GuiComponentServer.Type<Params, Float> TYPE = new GuiComponentServer.Type(MI.id("progress_bar"), Params.STREAM_CODEC, ByteBufCodecs.FLOAT);
    private final Params params;
    private final Supplier<Float> progressSupplier;

    public ProgressBar(Params params, Supplier<Float> progressSupplier) {
        this.params = params;
        this.progressSupplier = progressSupplier;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public Float extractData() {
        return this.progressSupplier.get();
    }

    @Override
    public GuiComponentServer.Type<Params, Float> getType() {
        return TYPE;
    }

    public record Params(int renderX, int renderY, String progressBarType, int width, int height, boolean isVertical) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Params::renderX, (StreamCodec)ByteBufCodecs.VAR_INT, Params::renderY, (StreamCodec)ByteBufCodecs.STRING_UTF8, Params::progressBarType, (StreamCodec)ByteBufCodecs.VAR_INT, Params::width, (StreamCodec)ByteBufCodecs.VAR_INT, Params::height, (StreamCodec)ByteBufCodecs.BOOL, Params::isVertical, Params::new);

        public Params(int renderX, int renderY, String progressBarType) {
            this(renderX, renderY, progressBarType, false);
        }

        public Params(int renderX, int renderY, String progressBarType, boolean isVertical) {
            this(renderX, renderY, progressBarType, 20, 20, isVertical);
        }

        public Params {
            if (width < 2 || height < 2) {
                throw new IllegalArgumentException("Width and height must be at least 2, currently " + width + " and " + height);
            }
        }

        public ResourceLocation getTextureId() {
            return MI.id("textures/gui/progress_bar/" + this.progressBarType + ".png");
        }

        public int textureHeight() {
            return 2 * this.height;
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.renderX, this.renderY, this.width, this.height);
        }
    }
}

