/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class RecipeEfficiencyBar
implements GuiComponentServer<Params, Data> {
    public static final GuiComponentServer.Type<Params, Data> TYPE = new GuiComponentServer.Type<Params, Data>(MI.id("recipe_efficiency_bar"), Params.STREAM_CODEC, Data.STREAM_CODEC);
    private final Params params;
    private final CrafterComponent crafter;

    public RecipeEfficiencyBar(Params params, CrafterComponent crafter) {
        this.params = params;
        this.crafter = crafter;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public Data extractData() {
        if (this.crafter.hasActiveRecipe()) {
            return new Data(true, this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu(), this.crafter.getBehavior().getMaxRecipeEu());
        }
        return new Data(false, 0, 0, 0L, 0L, this.crafter.getBehavior().getMaxRecipeEu());
    }

    @Override
    public GuiComponentServer.Type<Params, Data> getType() {
        return TYPE;
    }

    public record Params(int renderX, int renderY) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Params::renderX, (StreamCodec)ByteBufCodecs.VAR_INT, Params::renderY, Params::new);
    }

    public record Data(boolean hasActiveRecipe, int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu, long maxRecipeEu) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Data::hasActiveRecipe, (StreamCodec)ByteBufCodecs.VAR_INT, Data::efficiencyTicks, (StreamCodec)ByteBufCodecs.VAR_INT, Data::maxEfficiencyTicks, (StreamCodec)ByteBufCodecs.VAR_LONG, Data::currentRecipeEu, (StreamCodec)ByteBufCodecs.VAR_LONG, Data::baseRecipeEu, (StreamCodec)ByteBufCodecs.VAR_LONG, Data::maxRecipeEu, Data::new);
    }
}

