/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.DefaultedListWrapper;
import aztech.modern_industrialization.util.MIExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class MachineRecipe
implements Recipe<RecipeInput> {
    final MachineRecipeType type;
    public int eu;
    public int duration;
    public List<ItemInput> itemInputs = new ArrayList<ItemInput>();
    public List<FluidInput> fluidInputs = new ArrayList<FluidInput>();
    public List<ItemOutput> itemOutputs = new ArrayList<ItemOutput>();
    public List<FluidOutput> fluidOutputs = new ArrayList<FluidOutput>();
    public List<MachineProcessCondition> conditions = new ArrayList<MachineProcessCondition>();
    private static final MapCodec<Integer> AMOUNT_CODEC = NeoForgeExtraCodecs.mapWithAlternative((MapCodec)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount"), (MapCodec)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count")).xmap(deserialized -> deserialized.orElse(1), Optional::of);

    public static MapCodec<MachineRecipe> codec(MachineRecipeType type) {
        return RecordCodecBuilder.mapCodec(g -> g.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("eu").forGetter(recipe -> recipe.eu), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(recipe -> recipe.duration), (App)MIExtraCodecs.maybeList(ItemInput.CODEC, "item_inputs").forGetter(recipe -> recipe.itemInputs), (App)MIExtraCodecs.maybeList(FluidInput.CODEC, "fluid_inputs").forGetter(recipe -> recipe.fluidInputs), (App)MIExtraCodecs.maybeList(ItemOutput.CODEC, "item_outputs").forGetter(recipe -> recipe.itemOutputs), (App)MIExtraCodecs.maybeList(FluidOutput.CODEC, "fluid_outputs").forGetter(recipe -> recipe.fluidOutputs), (App)MIExtraCodecs.maybeList(MachineProcessCondition.CODEC, "process_conditions").forGetter(recipe -> recipe.conditions)).apply((Applicative)g, (eu, duration, itemInputs, fluidInputs, itemOutputs, fluidOutputs, conditions) -> {
            MachineRecipe ret = new MachineRecipe(type);
            ret.eu = eu;
            ret.duration = duration;
            ret.itemInputs = itemInputs;
            ret.fluidInputs = fluidInputs;
            ret.itemOutputs = itemOutputs;
            ret.fluidOutputs = fluidOutputs;
            ret.conditions = conditions;
            return ret;
        }));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, MachineRecipe> streamCodec(MachineRecipeType type) {
        return NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.VAR_INT, r -> r.eu, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.duration, (StreamCodec)ItemInput.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.itemInputs, (StreamCodec)FluidInput.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.fluidInputs, (StreamCodec)ItemOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.itemOutputs, (StreamCodec)FluidOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.fluidOutputs, (StreamCodec)MachineProcessCondition.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.conditions, (eu, duration, itemInputs, fluidInputs, itemOutputs, fluidOutputs, conditions) -> {
            MachineRecipe ret = new MachineRecipe(type);
            ret.eu = eu;
            ret.duration = duration;
            ret.itemInputs = itemInputs;
            ret.fluidInputs = fluidInputs;
            ret.itemOutputs = itemOutputs;
            ret.fluidOutputs = fluidOutputs;
            ret.conditions = conditions;
            return ret;
        });
    }

    MachineRecipe(MachineRecipeType type) {
        this.type = type;
    }

    public long getTotalEu() {
        return (long)this.eu * (long)this.duration;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(RecipeInput recipeInput, Level world) {
        throw new UnsupportedOperationException();
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider registryAccess) {
        throw new UnsupportedOperationException();
    }

    public boolean canCraftInDimensions(int width, int height) {
        throw new UnsupportedOperationException();
    }

    public NonNullList<Ingredient> getIngredients() {
        return new DefaultedListWrapper<Ingredient>(this.itemInputs.stream().filter(i -> i.probability == 1.0f).map(i -> {
            for (ItemStack stack : i.ingredient.getItems()) {
                stack.setCount(i.amount);
            }
            return i.ingredient;
        }).collect(Collectors.toList()));
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        for (ItemOutput o : this.itemOutputs) {
            if (o.probability != 1.0f) continue;
            return o.getStack();
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.type;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public boolean conditionsMatch(MachineProcessCondition.Context context) {
        for (MachineProcessCondition condition : this.conditions) {
            if (condition.canProcessRecipe(context, this)) continue;
            return false;
        }
        return true;
    }

    public record ItemInput(Ingredient ingredient, int amount, float probability) {
        public static final Codec<ItemInput> CODEC = RecordCodecBuilder.create(g -> g.group((App)Ingredient.MAP_CODEC_NONEMPTY.forGetter(ItemInput::ingredient), (App)AMOUNT_CODEC.forGetter(ItemInput::amount), (App)MIExtraCodecs.FLOAT_01.optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(ItemInput::probability)).apply((Applicative)g, ItemInput::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemInput> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemInput::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, ItemInput::amount, (StreamCodec)ByteBufCodecs.FLOAT, ItemInput::probability, ItemInput::new);

        public boolean matches(ItemStack otherStack) {
            return this.ingredient.test(otherStack);
        }

        public List<Item> getInputItems() {
            return Arrays.stream(this.ingredient.getItems()).map(ItemStack::getItem).distinct().collect(Collectors.toList());
        }
    }

    public record FluidInput(FluidIngredient fluid, long amount, float probability) {
        public static final Codec<FluidInput> CODEC = RecordCodecBuilder.create(g -> g.group((App)FluidIngredient.MAP_CODEC_NONEMPTY.forGetter(FluidInput::fluid), (App)NeoForgeExtraCodecs.optionalFieldAlwaysWrite(MIExtraCodecs.POSITIVE_LONG, (String)"amount", (Object)1L).forGetter(FluidInput::amount), (App)MIExtraCodecs.FLOAT_01.optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(FluidInput::probability)).apply((Applicative)g, FluidInput::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidInput> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, FluidInput::fluid, (StreamCodec)ByteBufCodecs.VAR_LONG, FluidInput::amount, (StreamCodec)ByteBufCodecs.FLOAT, FluidInput::probability, FluidInput::new);

        @Deprecated(forRemoval=true)
        public FluidInput(Fluid fluid, long amount, float probability) {
            this(FluidIngredient.of((Fluid[])new Fluid[]{fluid}), amount, probability);
        }

        public List<Fluid> getInputFluids() {
            return Arrays.stream(this.fluid.getStacks()).map(FluidStack::getFluid).distinct().collect(Collectors.toList());
        }
    }

    public record ItemOutput(ItemVariant variant, int amount, float probability) {
        public static final Codec<ItemOutput> CODEC = RecordCodecBuilder.create(g -> g.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").forGetter(itemOutput -> itemOutput.variant.getItem().builtInRegistryHolder()), (App)AMOUNT_CODEC.forGetter(itemOutput -> itemOutput.amount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemOutput -> itemOutput.variant.getComponentsPatch()), (App)MIExtraCodecs.FLOAT_01.optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(itemOutput -> Float.valueOf(itemOutput.probability))).apply((Applicative)g, (item, count, components, probability) -> new ItemOutput(ItemVariant.of(new ItemStack(item, 1, components)), (int)count, probability.floatValue())));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemOutput> STREAM_CODEC = StreamCodec.composite(ItemVariant.STREAM_CODEC, ItemOutput::variant, (StreamCodec)ByteBufCodecs.VAR_INT, ItemOutput::amount, (StreamCodec)ByteBufCodecs.FLOAT, ItemOutput::probability, ItemOutput::new);

        public ItemStack getStack() {
            return this.variant.toStack(this.amount);
        }
    }

    public record FluidOutput(Fluid fluid, long amount, float probability) {
        public static final Codec<FluidOutput> CODEC = RecordCodecBuilder.create(g -> g.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(fluidOutput -> fluidOutput.fluid), (App)NeoForgeExtraCodecs.optionalFieldAlwaysWrite(MIExtraCodecs.POSITIVE_LONG, (String)"amount", (Object)1L).forGetter(fluidOutput -> fluidOutput.amount), (App)MIExtraCodecs.FLOAT_01.optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(fluidOutput -> Float.valueOf(fluidOutput.probability))).apply((Applicative)g, FluidOutput::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), FluidOutput::fluid, (StreamCodec)ByteBufCodecs.VAR_LONG, FluidOutput::amount, (StreamCodec)ByteBufCodecs.FLOAT, FluidOutput::probability, FluidOutput::new);
    }
}

