/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.recipe.condition.AdjacentBlockProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.BiomeProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.CustomProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.DimensionProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public final class MachineProcessConditions {
    private static final BiMap<ResourceLocation, MapCodec<? extends MachineProcessCondition>> MAP = HashBiMap.create();
    private static final BiMap<ResourceLocation, StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition>> STREAM_MAP = HashBiMap.create();

    public static <T extends MachineProcessCondition> void register(ResourceLocation id, MapCodec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        if (MAP.get((Object)id) != null || MAP.inverse().get(codec) != null || STREAM_MAP.inverse().get(streamCodec) != null) {
            throw new IllegalArgumentException("Duplicate registration for process condition " + String.valueOf(id));
        }
        MAP.put((Object)id, codec);
        STREAM_MAP.put((Object)id, streamCodec);
    }

    public static @Nullable MapCodec<? extends MachineProcessCondition> getCodec(ResourceLocation id) {
        return (MapCodec)MAP.get((Object)id);
    }

    public static @Nullable StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> getStreamCodec(ResourceLocation id) {
        return (StreamCodec)STREAM_MAP.get((Object)id);
    }

    public static ResourceLocation getId(MapCodec<? extends MachineProcessCondition> codec) {
        return (ResourceLocation)MAP.inverse().get(codec);
    }

    public static ResourceLocation getId(StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec) {
        return (ResourceLocation)STREAM_MAP.inverse().get(streamCodec);
    }

    static {
        MachineProcessConditions.register(MI.id("dimension"), DimensionProcessCondition.CODEC, DimensionProcessCondition.STREAM_CODEC);
        MachineProcessConditions.register(MI.id("adjacent_block"), AdjacentBlockProcessCondition.CODEC, AdjacentBlockProcessCondition.STREAM_CODEC);
        MachineProcessConditions.register(MI.id("biome"), BiomeProcessCondition.CODEC, BiomeProcessCondition.STREAM_CODEC);
        MachineProcessConditions.register(MI.id("custom"), CustomProcessCondition.CODEC, CustomProcessCondition.STREAM_CODEC);
    }
}

