/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public record FluidNuclearComponent(FluidVariant variant, double heatConduction, NeutronBehaviour neutronBehaviour, FluidVariant neutronProduct, long neutronProductAmount, double neutronProductProbability) implements NuclearComponent<FluidVariant>
{
    private static final Map<Fluid, FluidNuclearComponent> registry = new IdentityHashMap<Fluid, FluidNuclearComponent>();

    public FluidNuclearComponent(Fluid fluid, double heatConduction, double density, NuclearConstant.ScatteringType type, IsotopeParams params, FluidVariant neutronProduct, long neutronProductAmount, double neutronProductProbability) {
        this(FluidVariant.of(fluid), heatConduction * density, NeutronBehaviour.of(type, params, density), neutronProduct, neutronProductAmount, neutronProductProbability);
    }

    @Override
    public FluidVariant getVariant() {
        return this.variant;
    }

    @Override
    public double getHeatConduction() {
        return this.heatConduction;
    }

    @Override
    public NeutronBehaviour getNeutronBehaviour() {
        return this.neutronBehaviour;
    }

    @Override
    public FluidVariant getNeutronProduct() {
        return this.neutronProduct;
    }

    @Override
    public long getNeutronProductAmount() {
        return this.neutronProductAmount;
    }

    @Override
    public double getNeutronProductProbability() {
        return this.neutronProductProbability;
    }

    public static void register(FluidNuclearComponent component) {
        Fluid fluid = component.getVariant().getFluid();
        if (registry.containsKey(fluid)) {
            throw new IllegalArgumentException("Already registered fluid-neutron interaction for " + String.valueOf(fluid));
        }
        registry.put(fluid, component);
    }

    public static void remove(Fluid fluid) {
        registry.remove(fluid);
    }

    public static @Nullable FluidNuclearComponent get(Fluid fluid) {
        return registry.get(fluid);
    }

    public static void init() {
        FluidNuclearComponent.register(new FluidNuclearComponent((Fluid)Fluids.WATER, 0.05, 1.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), 1L, 1.0));
        FluidNuclearComponent.register(new FluidNuclearComponent(MIFluids.HEAVY_WATER.asFluid(), 0.06, 1.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), 1L, 1.0));
        FluidNuclearComponent.register(new FluidNuclearComponent(MIFluids.HIGH_PRESSURE_WATER.asFluid(), 0.05, 4.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), 8L, 0.125));
        FluidNuclearComponent.register(new FluidNuclearComponent(MIFluids.HIGH_PRESSURE_HEAVY_WATER.asFluid(), 0.06, 4.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), 8L, 0.125));
        KubeJSProxy.instance.fireRegisterFluidNeutronInteractionsEvent();
    }
}

