/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import com.google.common.base.Preconditions;

public interface NeutronBehaviour {
    public static final NeutronBehaviour NO_INTERACTION = new NeutronBehaviour(){

        @Override
        public double neutronSlowingProbability() {
            return 0.5;
        }

        @Override
        public double interactionTotalProbability(NeutronType type) {
            return 0.0;
        }

        @Override
        public double interactionRelativeProbability(NeutronType type, NeutronInteraction interaction) {
            return 0.5;
        }
    };

    public double neutronSlowingProbability();

    public double interactionTotalProbability(NeutronType var1);

    public double interactionRelativeProbability(NeutronType var1, NeutronInteraction var2);

    public static NeutronBehaviour of(final NuclearConstant.ScatteringType scatteringType, final double thermalNeutronAbsorptionBarn, final double fastNeutronAbsorptionBarn, final double thermalNeutronScatteringBarn, final double fastNeutronScatteringBarn, final double size) {
        return new NeutronBehaviour(){
            final double thermalProbability;
            final double fastProbability;
            {
                this.thermalProbability = NeutronBehaviour.probaFromCrossSection((thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn) * Math.sqrt(size));
                this.fastProbability = NeutronBehaviour.probaFromCrossSection((fastNeutronAbsorptionBarn + fastNeutronScatteringBarn) * Math.sqrt(size));
            }

            @Override
            public double neutronSlowingProbability() {
                return scatteringType.slowFraction;
            }

            @Override
            public double interactionTotalProbability(NeutronType type) {
                Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
                if (type == NeutronType.FAST) {
                    return this.fastProbability;
                }
                if (type == NeutronType.THERMAL) {
                    return this.thermalProbability;
                }
                return 0.0;
            }

            @Override
            public double interactionRelativeProbability(NeutronType type, NeutronInteraction interaction) {
                Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
                if (type == NeutronType.THERMAL) {
                    if (interaction == NeutronInteraction.SCATTERING) {
                        return thermalNeutronScatteringBarn / (thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn);
                    }
                    if (interaction == NeutronInteraction.ABSORPTION) {
                        return thermalNeutronAbsorptionBarn / (thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn);
                    }
                } else if (type == NeutronType.FAST) {
                    if (interaction == NeutronInteraction.SCATTERING) {
                        return fastNeutronScatteringBarn / (fastNeutronAbsorptionBarn + fastNeutronScatteringBarn);
                    }
                    if (interaction == NeutronInteraction.ABSORPTION) {
                        return fastNeutronAbsorptionBarn / (fastNeutronAbsorptionBarn + fastNeutronScatteringBarn);
                    }
                }
                return 0.0;
            }
        };
    }

    public static double crossSectionFromProba(double proba) {
        return -Math.log(1.0 - proba);
    }

    public static double probaFromCrossSection(double crossSection) {
        return 1.0 - Math.exp(-crossSection);
    }

    public static NeutronBehaviour of(NuclearConstant.ScatteringType scatteringType, IsotopeParams params, double size) {
        return NeutronBehaviour.of(scatteringType, params.thermalAbsorption, params.fastAbsorption, params.thermalScattering, params.fastScattering, size);
    }

    public static double reduceCrossProba(double proba, double crossSectionFactor) {
        return NeutronBehaviour.probaFromCrossSection(NeutronBehaviour.crossSectionFromProba(proba) * crossSectionFactor);
    }
}

