/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.network.pipes.SetConnectionTypePacket;
import aztech.modern_industrialization.network.pipes.SetItemWhitelistPacket;
import aztech.modern_industrialization.network.pipes.SetPriorityPacket;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.gui.PipeScreenHandler;
import aztech.modern_industrialization.pipes.item.ItemPipeInterface;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.UnsupportedOperationInventory;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemPipeScreenHandler
extends PipeScreenHandler {
    public static final int HEIGHT = 196;
    private final Inventory playerInventory;
    public final ItemPipeInterface pipeInterface;
    private boolean trackedWhitelist;
    private int trackedPriority0;
    private int trackedPriority1;
    private int trackedType;
    public static final int UPGRADE_SLOT_X = 150;
    public static final int UPGRADE_SLOT_Y = 70;

    public ItemPipeScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, ItemPipeInterface.ofBuf(buf));
    }

    public ItemPipeScreenHandler(int syncId, Inventory playerInventory, ItemPipeInterface pipeInterface) {
        super(MIPipes.SCREEN_HANDLER_TYPE_ITEM_PIPE.get(), syncId);
        this.playerInventory = playerInventory;
        this.pipeInterface = pipeInterface;
        this.trackedWhitelist = pipeInterface.isWhitelist();
        this.trackedPriority0 = pipeInterface.getPriority(0);
        this.trackedPriority1 = pipeInterface.getPriority(1);
        this.trackedType = pipeInterface.getConnectionType();
        this.addPlayerInventorySlots(playerInventory, 196);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.addSlot(new FilterSlot(i * 7 + j, 16 + 18 * j, 18 + 18 * i));
            }
        }
        this.addSlot(new UpgradeSlot(150, 70));
    }

    public void clicked(int i, int j, ClickType actionType, Player playerEntity) {
        Slot slot;
        if (i >= 0 && (slot = (Slot)this.slots.get(i)) instanceof FilterSlot) {
            if (actionType == ClickType.PICKUP) {
                slot.set(this.getCarried().copy());
            } else if (actionType == ClickType.QUICK_MOVE) {
                slot.set(ItemStack.EMPTY);
            }
            return;
        }
        super.clicked(i, j, actionType, playerEntity);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            if (index < 36) {
                int i;
                if (this.moveItemStackTo(slot.getItem(), 57, 58, false)) {
                    return ItemStack.EMPTY;
                }
                for (i = 0; i < 21; ++i) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)((Slot)this.slots.get(36 + i)).getItem(), (ItemStack)slot.getItem())) continue;
                    return ItemStack.EMPTY;
                }
                for (i = 0; i < 21; ++i) {
                    if (!this.pipeInterface.getStack(i).isEmpty()) continue;
                    ((Slot)this.slots.get(36 + i)).set(slot.getItem().copy());
                    break;
                }
            } else if (index == 57) {
                if (!this.moveItemStackTo(slot.getItem(), 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                throw new RuntimeException("Can't transfer slot from that index.");
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.pipeInterface.canUse(player);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.playerInventory.player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)this.playerInventory.player;
            if (this.trackedWhitelist != this.pipeInterface.isWhitelist()) {
                this.trackedWhitelist = this.pipeInterface.isWhitelist();
                new SetItemWhitelistPacket(this.containerId, this.trackedWhitelist).sendToClient(serverPlayer);
            }
            if (this.trackedType != this.pipeInterface.getConnectionType()) {
                this.trackedType = this.pipeInterface.getConnectionType();
                new SetConnectionTypePacket(this.containerId, this.trackedType).sendToClient(serverPlayer);
            }
            if (this.trackedPriority0 != this.pipeInterface.getPriority(0)) {
                this.trackedPriority0 = this.pipeInterface.getPriority(0);
                new SetPriorityPacket(this.containerId, 0, this.trackedPriority0).sendToClient(serverPlayer);
            }
            if (this.trackedPriority1 != this.pipeInterface.getPriority(1)) {
                this.trackedPriority1 = this.pipeInterface.getPriority(1);
                new SetPriorityPacket(this.containerId, 1, this.trackedPriority1).sendToClient(serverPlayer);
            }
        }
    }

    @Override
    protected Object getInterface() {
        return this.pipeInterface;
    }

    private class FilterSlot
    extends Slot
    implements ReiDraggable {
        private final int index;

        public FilterSlot(int index, int x, int y) {
            super((Container)new UnsupportedOperationInventory(), index, x, y);
            this.index = index;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player playerEntity) {
            return false;
        }

        public ItemStack getItem() {
            return ItemPipeScreenHandler.this.pipeInterface.getStack(this.index);
        }

        public void set(ItemStack stack) {
            if (!stack.isEmpty()) {
                stack.setCount(1);
            }
            ItemPipeScreenHandler.this.pipeInterface.setStack(this.index, stack);
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            return false;
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            if (simulation.isActing()) {
                this.set(itemKey.toStack());
            }
            return true;
        }
    }

    public class UpgradeSlot
    extends Slot {
        public UpgradeSlot(int x, int y) {
            super((Container)new UnsupportedOperationInventory(), -1, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            if (ItemPipeScreenHandler.this.pipeInterface.getConnectionType() == 0) {
                return false;
            }
            return stack.getItemHolder().getData(MIDataMaps.ITEM_PIPE_UPGRADES) != null;
        }

        public boolean isHighlightable() {
            return ItemPipeScreenHandler.this.pipeInterface.getConnectionType() != 0;
        }

        public ItemStack getItem() {
            return ItemPipeScreenHandler.this.pipeInterface.getUpgradeStack();
        }

        public void set(ItemStack stack) {
            ItemPipeScreenHandler.this.pipeInterface.setUpgradeStack(stack);
        }

        public void setChanged() {
        }

        public int getMaxStackSize(ItemStack stack) {
            return 64;
        }

        public ItemStack remove(int amount) {
            return ItemPipeScreenHandler.this.pipeInterface.getUpgradeStack().split(amount);
        }
    }
}

