/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.recipe.json;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.recipe.json.MIRecipeBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class ShapedRecipeJson
implements MIRecipeBuilder {
    public final String type = "minecraft:crafting_shaped";
    public final String[] pattern;
    public final Map<Character, Ingredient> key = new HashMap<Character, Ingredient>();
    public final ItemStack result;

    public ShapedRecipeJson(String resultItem, int count, String ... pattern) {
        this.pattern = pattern;
        this.result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)resultItem)), count);
    }

    public ShapedRecipeJson addInput(char key, String maybeTag) {
        Ingredient input = maybeTag.startsWith("#") ? Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)maybeTag.substring(1)))) : Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)maybeTag))});
        if (this.key.put(Character.valueOf(key), input) != null) {
            throw new IllegalStateException("Key mapping is already registered: " + key);
        }
        return this;
    }

    public void validate() {
        if (this.pattern.length == 0 || this.pattern.length > 3) {
            throw new IllegalArgumentException("Invalid length " + this.pattern.length);
        }
        for (String string : this.pattern) {
            if (string.length() == this.pattern[0].length()) continue;
            throw new IllegalArgumentException("Pattern length mismatch: " + string.length() + ", expected " + this.pattern[0].length());
        }
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ' || this.key.containsKey(Character.valueOf(string.charAt(i)))) continue;
                throw new IllegalArgumentException("Key " + string.charAt(i) + " is missing a mapping.");
            }
        }
        Iterator<Character> iterator = this.key.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            boolean ok = false;
            block4: for (String string : this.pattern) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != c) continue;
                    ok = true;
                    continue block4;
                }
            }
            if (ok) continue;
            throw new IllegalArgumentException("Key mapping '" + c + "' is not used in the pattern.");
        }
    }

    public MachineRecipeBuilder exportToAssembler() {
        return this.exportToMachine(MIMachineRecipeTypes.ASSEMBLER, 8, 200, 1);
    }

    public MachineRecipeBuilder exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        if (this.result.getCount() % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MachineRecipeBuilder assemblerJson = (MachineRecipeBuilder)new MachineRecipeBuilder(machine, eu, duration).addItemOutput(this.result.getItem(), this.result.getCount() / division);
        for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
            int count = 0;
            for (String row : this.pattern) {
                for (char c : row.toCharArray()) {
                    if (c != entry.getKey().charValue()) continue;
                    ++count;
                }
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            assemblerJson.addItemInput(entry.getValue(), count / division, 1.0f);
        }
        return assemblerJson;
    }

    @Override
    public void offerTo(RecipeOutput recipeOutput, String path) {
        recipeOutput.accept(MI.id(path), (Recipe)new ShapedRecipe("", CraftingBookCategory.MISC, ShapedRecipePattern.of(this.key, (String[])this.pattern), this.result), null);
    }
}

