/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.stats;

import aztech.modern_industrialization.compat.argonauts.ArgonautsFacade;
import aztech.modern_industrialization.compat.ftbquests.FTBQuestsFacade;
import aztech.modern_industrialization.compat.ftbteams.FTBTeamsFacade;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.stats.StatisticValue;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public class PlayerStatistics {
    public static final PlayerStatistics DUMMY = new PlayerStatistics(null, null);
    private final PlayerStatisticsData data;
    private final @Nullable UUID uuid;
    private final Map<Item, StatisticValue> usedItems = new IdentityHashMap<Item, StatisticValue>();
    private final Map<Item, StatisticValue> producedItems = new IdentityHashMap<Item, StatisticValue>();
    private final Map<Fluid, StatisticValue> usedFluids = new IdentityHashMap<Fluid, StatisticValue>();
    private final Map<Fluid, StatisticValue> producedFluids = new IdentityHashMap<Fluid, StatisticValue>();
    private static final Set<UUID> uuidCache = new HashSet<UUID>();
    private final Reference2LongMap<Item> pendingCraftedStats = new Reference2LongOpenHashMap();

    PlayerStatistics(PlayerStatisticsData data, UUID uuid) {
        this.data = data;
        this.uuid = uuid;
    }

    PlayerStatistics(PlayerStatisticsData data, UUID uuid, CompoundTag nbt) {
        this(data, uuid);
        PlayerStatistics.readNbt(BuiltInRegistries.ITEM, this.usedItems, nbt.getCompound("usedItems"));
        PlayerStatistics.readNbt(BuiltInRegistries.ITEM, this.producedItems, nbt.getCompound("producedItems"));
        PlayerStatistics.readNbt(BuiltInRegistries.FLUID, this.usedFluids, nbt.getCompound("usedFluids"));
        PlayerStatistics.readNbt(BuiltInRegistries.FLUID, this.producedFluids, nbt.getCompound("producedFluids"));
        PlayerStatistics.pendingReadNbt(this.pendingCraftedStats, nbt.getCompound("pendingCraftedStats"));
    }

    public CompoundTag toTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("usedItems", (Tag)PlayerStatistics.toNbt(BuiltInRegistries.ITEM, this.usedItems));
        nbt.put("producedItems", (Tag)PlayerStatistics.toNbt(BuiltInRegistries.ITEM, this.producedItems));
        nbt.put("usedFluids", (Tag)PlayerStatistics.toNbt(BuiltInRegistries.FLUID, this.usedFluids));
        nbt.put("producedFluids", (Tag)PlayerStatistics.toNbt(BuiltInRegistries.FLUID, this.producedFluids));
        nbt.put("pendingCraftedStats", (Tag)PlayerStatistics.pendingToNbt(this.pendingCraftedStats));
        return nbt;
    }

    public void addUsedItems(ItemLike what, long amount) {
        this.usedItems.computeIfAbsent(what.asItem(), i -> new StatisticValue()).add(amount);
    }

    public void addProducedItems(Level level, ItemLike what, long amount) {
        Item item = what.asItem();
        this.producedItems.computeIfAbsent(item, i -> new StatisticValue()).add(amount);
        if (this.uuid != null) {
            FTBQuestsFacade.INSTANCE.addCompleted(this.uuid, item, amount);
            this.awardStat(level, what, amount);
            uuidCache.clear();
            uuidCache.addAll(FTBTeamsFacade.INSTANCE.getOtherPlayersInTeam(this.uuid));
            uuidCache.addAll(ArgonautsFacade.INSTANCE.getOtherPlayersInGuild(level, this.uuid));
            for (UUID uuid : uuidCache) {
                this.data.get(uuid).awardStat(level, what, amount);
            }
            uuidCache.clear();
        }
    }

    public void addUsedFluids(Fluid what, long amount) {
        this.usedFluids.computeIfAbsent(what, i -> new StatisticValue()).add(amount);
    }

    public void addProducedFluids(Fluid what, long amount) {
        this.producedFluids.computeIfAbsent(what, i -> new StatisticValue()).add(amount);
    }

    private void awardStat(Level level, ItemLike what, long amount) {
        Objects.requireNonNull(this.uuid);
        Player player = level.getPlayerByUUID(this.uuid);
        if (player != null) {
            player.awardStat(Stats.ITEM_CRAFTED.get((Object)what.asItem()), Ints.saturatedCast((long)amount));
        } else {
            this.pendingCraftedStats.mergeLong((Object)what.asItem(), amount, Long::sum);
        }
    }

    public void onPlayerJoin(ServerPlayer player) {
        if (!this.pendingCraftedStats.isEmpty()) {
            for (Reference2LongMap.Entry entry : this.pendingCraftedStats.reference2LongEntrySet()) {
                player.awardStat(Stats.ITEM_CRAFTED.get((Object)((Item)entry.getKey())), Ints.saturatedCast((long)entry.getLongValue()));
            }
            this.pendingCraftedStats.clear();
        }
    }

    private static <T> void readNbt(Registry<T> registry, Map<T, StatisticValue> map, CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            try {
                Object val = registry.get(ResourceLocation.parse((String)key));
                if (val == Items.AIR || val == Fluids.EMPTY) continue;
                map.put(val, new StatisticValue(tag.getCompound(key)));
            }
            catch (Exception exception) {}
        }
    }

    private static <T> CompoundTag toNbt(Registry<T> registry, Map<T, StatisticValue> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<T, StatisticValue> entry : map.entrySet()) {
            tag.put(registry.getKey(entry.getKey()).toString(), (Tag)entry.getValue().toNbt());
        }
        return tag;
    }

    private static void pendingReadNbt(Reference2LongMap<Item> map, CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            try {
                Item val = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)key));
                if (val == Items.AIR) continue;
                map.put((Object)val, tag.getLong(key));
            }
            catch (Exception exception) {}
        }
    }

    private static CompoundTag pendingToNbt(Reference2LongMap<Item> map) {
        CompoundTag tag = new CompoundTag();
        for (Reference2LongMap.Entry entry : map.reference2LongEntrySet()) {
            tag.putLong(BuiltInRegistries.ITEM.getKey((Object)((Item)entry.getKey())).toString(), entry.getLongValue());
        }
        return tag;
    }
}

