---
navigation:
  title: "原子炉"
  icon: "modern_industrialization:uranium_fuel_rod_quad"
  position: 206
  parent: modern_industrialization:midgame.md
item_ids:
  - modern_industrialization:nuclear_reactor
  - modern_industrialization:nuclear_casing
  - modern_industrialization:nuclear_item_hatch
  - modern_industrialization:nuclear_fluid_hatch
---

# 原子炉

原子炉は、核燃料を消費して大量のエネルギーを生成することを目的とした大型のマルチブロックである。ディーゼルの100倍以上のEU/tを生み出すことができる。小型から大型までいくつかのサイズがある。

<Recipe id="modern_industrialization:electric_age/machine/nuclear_reactor_asbl" />

原子炉を使って発電するには、何らかの形の水を核流体ハッチに入れる必要がある。水は蒸気に変わり、熱交換器に通すことで発電に利用できるようになる。

原子炉はまた、プルトニウムのような一部の物質を生産する唯一の方法でもある。

最後に、核融合に使われる流体を生成することができる: 重水素と三重水素だ。

以下のページで説明することになるが、内部でどのような動作が起こるかは少しわかりにくいかもしれない。 ただし、強力な炉を設計するために詳細を理解する必要はない。

自分に合った設計が見つかるまで、クリエイティブモードでさまざまな設計を試してみることを推奨する。

なお、原子炉は爆発したり、放射線を放出したり、マップにダメージを与えることはできない。唯一ダメージを与えることができるのは、温度が高くなりすぎたときに中に入れたアイテムのみである(これについては後述する)

自由に実験して、原子力科学者としての新しい人生を楽しもう！

主な構成部品は、カドミウム、ベリリウム、耐爆合金の混合物である原子力合金で作られた原子力合金の筐体である。

<Recipe id="modern_industrialization:electric_age/casing/nuclear_casing_asbl" />

構造物の上部には原子力合金アイテムハッチ、あるいは原子力合金流体ハッチ(またはただの筐体)が設置されることになる。これらは原子炉の入力と出力である。

<Recipe id="modern_industrialization:electric_age/casing/nuclear_item_hatch_asbl" />

各ハッチには1つの入力(アイテムまたは流体)と2つの出力がある。入力スロットはグリッドを形成し、リアクターGUI(コントローラを右クリックしてアクセスできる)に表示される。

<Recipe id="modern_industrialization:electric_age/casing/nuclear_fluid_hatch_asbl" />

各ハッチには温度があり、いくつか方法で発散できる熱を蓄える。熱は自然に隣接するハッチに移動するか、ハッチは端にある場合は外側へと移動する(そしてこの時に熱は失われる)。この過程の速度はハッチの内容物の伝達係数(REIで表示)と温度差の積に等しい。流体ハッチ内で蒸気を生成して取り出すことも可能である。アイテムの最高温度を超える温度は、アイテムを破壊する。

原子炉の核となる要素は中性子である。これは核燃料から発生する。中性子には高速中性子と熱中性子の2種類があり、高速中性子はエネルギーを持ち、熱中性子はエネルギーを持たない。中性子は、要素に出会うか原子炉から出るまで(高速中性子の場合エネルギーはその後失われる)一直線に進む。中性子の流れは原子炉のGUIに表示される。

中性子が空でないハッチに遭遇すると、二つのことが起こり得る: 吸収されるか散乱されるかだ。散乱された中性子はランダムに方向を変える。散乱された中性子が高速の場合、減速して熱中性子になる可能性がある。これにより中性子からハッチにエネルギーが熱の形で伝わる。吸収された中性子は進路を止め、高速中性子であればエネルギーも移動する。

一つのハッチに吸収された中性子の数はGUIで確認できる。各プロセスの確率はREIで表示される。これらはハッチの内容と中性子の種類(高速中性子か熱中性子か)に強く依存する。核燃料は熱中性子をはるかによく吸収する。

高速中性子と熱中性子のどちらであろうとも、中性子が核燃料に吸収されるとさらに中性子が発生する。それらは常に高速中性子であり、ランダムな方向を持つ。中性子の発生はハッチ内の追加の熱という形でエネルギーの直接放出を伴う。

ある閾値を超えると、発生する中性子の数は温度とともに減少しゼロになる。このプロセスは若干のエネルギーを消費するが、原子炉の安定性を保証する。発生中性子数(および実効効率)、直接エネルギー、温度の閾値はREIの通りである。

それぞれの核成分には最大吸収回数がある。最大数に達するとそのアイテムは破壊されるか、使用済版に変換される。これはウラン-238の使用済み燃料の一部がプルトニウムに変換され、その一部が燃料に戻ることを意味するため、核燃料にとって特に有用である。

流体でも同じことが起こる: 中性子が吸収されるたびに流体が少しずつ変化する。これは、重水素や三重水素のような有用な同位体を大量に生産するために使用できる。どちらの場合も結果はREIで示される。

