---
navigation:
  title: "Ядерний реактор"
  icon: "modern_industrialization:uranium_fuel_rod_quad"
  position: 206
  parent: modern_industrialization:midgame.md
item_ids:
  - modern_industrialization:nuclear_reactor
  - modern_industrialization:nuclear_casing
  - modern_industrialization:nuclear_item_hatch
  - modern_industrialization:nuclear_fluid_hatch
---

# Ядерний реактор

Ядерний реактор — це великий багатоблок, мета якого — генерувати величезну кількість енергії за рахунок використання ядерного палива. Він може виробляти в 100 разів більше EU/т, ніж дизель. Він доступний у кількох розмірах від малого до величезного.

<Recipe id="modern_industrialization:electric_age/machine/nuclear_reactor_asbl" />

Щоб виробляти енергію за допомогою ядерного реактора, вам потрібно помістити якусь воду в шлюз для ядерної рідини. Вона перетвориться на пару, яку потім можна використовувати для виробництва енергії, можливо, пропустивши її спочатку через теплообмінник.

Ядерний реактор також є єдиним способом виробництва деяких матеріалів, таких як плутоній.

Нарешті, він може виробляють рідини, які використовуються для ядерного синтезу: дейтерій і тритій.

Те, як це працює всередині, може бути трохи приголомшливим, незважаючи на наступні сторінки, які намагаються це пояснити. Тим не менш, вам не потрібно розумітися на деталях, щоб мати змогу спроєктувати потужний реактор.

Ми рекомендуємо вам експериментувати з різними конструкціями у творчому режимі, доки не знайдете ту, яка вам підходить.

Зверніть увагу, що ядерний реактор не може вибухнути, випромінювати радіацію чи іншим чином пошкодити світ. Єдине, що він може пошкодити, це предмети, які ви в нього помістите, якщо температура стане надто високою (докладніше про це пізніше).

Ви можете сміливо експериментувати та насолоджуватися новим життям вченого-ядерника!

Основним компонентом є обшивка, виготовлена із ядерного сплаву: суміші кадмію, берилію та вибухостійкого сплаву.

<Recipe id="modern_industrialization:electric_age/casing/nuclear_casing_asbl" />

Верхня частина конструкції приймає ядерні предмтні або рідинні шлюзи (або прості обшивки). Це входи і виходи реактора.

<Recipe id="modern_industrialization:electric_age/casing/nuclear_item_hatch_asbl" />

Кожен шлюз має один вхід (або предмет, або рідина) і два виходи. Вхідні слоти утворять сітку, яка відображатиметься в меню реактора (ПКМ на контролері).

<Recipe id="modern_industrialization:electric_age/casing/nuclear_fluid_hatch_asbl" />

Кожен шлюз має певну температуру та зберігає тепло, яке можна розсіювати кількома способами. Тепло буде природним чином переходити до сусіднього шлюза або назовні, якщо шлюз знаходиться на краю (тоді тепло втрачається). Швидкість цього процесу дорівнює коефіцієнту теплопередачі вмісту шлюзів (показано в REI), помноженому на різницю температур. Тепло також може бути відібрано в рідинному шлюзі шляхом виробництва пари. Температура вище максимальної температури предмета знищить його.

Елементами активної зони ядерного реактора є нейтрони. Їх виробляє ядерне паливо. Існує два типи нейтронів: швидкі й теплові: швидкі несуть енергію, а теплові — ні. Нейтрони рухаються по прямій лінії, поки не зустрінуть елемент або не вийдуть з реактора (для швидких нейтронів їхня енергія тоді втрачається). Потік нейтронів показано в меню реактора

Коли нейтрон стикається з непорожнім шлюзом, можуть статися дві речі: нейтрон поглинається або розсіюється. Розсіяний нейтрон буде випадково змінювати напрямок. Якщо розсіяний нейтрон швидкий, він має шанс сповільнитися, перетворившись на тепловий. Це передає енергію від нейтрона до шлюза у вигляді тепла. Поглинутий нейтрон зупиняє свій хід і також передає свою енергію, якщо це був швидкий нейтрон.

Кількість поглинених нейтронів в одному слоті можна побачити в інтерфейсі. Імовірність для кожного процесу показано в REI. Вони сильно залежатимуть від вмісту шлюза та типу нейтронів (швидких чи теплових). Ядерне паливо набагато краще поглинає теплові нейтрони.

Коли нейтрон, швидкий або тепловий, поглинається ядерним паливом, утворюється більше нейтронів. Це завжди швидкі нейтрони і вони мають випадковий напрямок. Їх генерація супроводжується прямим виділенням енергії у вигляді додаткового тепла в шлюзі.

Вище певного порогу кількість генерованих нейтронів зменшуватиметься разом із температурою, поки не досягне нуля. Цей процес витрачає деяку кількість енергії, але гарантує стабільність реактора. Кількість генерованих нейтронів (та ефективна ефективність), пряма енергія та поріг температури вказані в REI.

Кожен ядерний компонент має максимальну кількість поглинань. Коли предмет досягає, він або знищується, або перетворюється на виснажену версію. Це особливо корисно для ядерного палива, оскільки деяка частина урану-238 перетворюється на плутоній у збіднілій версії, тобто деяку його частину можна перетворити назад у паливо.

Те ж саме відбувається з рідинами: трохи рідини трансформується після кожного поглинання нейтрона. Це можна використовувати для масового виробництва таких корисних ізотопів, як дейтерій і тритій. В обох випадках результат показується в REI.

