/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class MysticalEssenceItem
extends BaseItem
implements ICropProvider {
    private final Crop crop;

    public MysticalEssenceItem(Crop crop) {
        this.crop = crop;
    }

    public Component getName(ItemStack stack) {
        return Localizable.of((String)"item.mysticalagriculture.mystical_essence").args(new Object[]{this.crop.getDisplayName()}).build();
    }

    public Component getDescription() {
        return this.getName(ItemStack.EMPTY);
    }

    public String getDescriptionId() {
        return Localizable.of((String)"item.mysticalagriculture.mystical_essence").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public boolean isFoil(ItemStack stack) {
        return this.crop.hasEffect(stack) || super.isFoil(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!this.crop.getModId().equals("mysticalagriculture")) {
            tooltip.add(ModTooltips.getAddedByTooltip(this.crop.getModId()));
        }
    }

    @Override
    public Crop getCrop() {
        return this.crop;
    }
}

