/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.util;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.network.payloads.ReloadIngredientCachePayload;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class RecipeIngredientCache {
    public static final RecipeIngredientCache INSTANCE = new RecipeIngredientCache();
    private final Map<RecipeType<?>, Map<Item, List<Ingredient>>> caches = new HashMap();
    private final Set<Item> validVesselItems = new HashSet<Item>();

    private RecipeIngredientCache() {
    }

    @SubscribeEvent
    public void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        ReloadIngredientCachePayload payload = new ReloadIngredientCachePayload(this.caches, this.validVesselItems);
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.caches.clear();
            RecipeIngredientCache.cache(RecipeType.SMELTING);
            RecipeIngredientCache.cache((RecipeType)ModRecipeTypes.REPROCESSOR.get());
            RecipeIngredientCache.cache((RecipeType)ModRecipeTypes.SOUL_EXTRACTION.get());
            RecipeIngredientCache.cache((RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get());
            this.validVesselItems.clear();
            RecipeIngredientCache.cacheVesselItems();
            MysticalAgriculture.LOGGER.info("Recipe ingredient caching done in {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public void setCaches(Map<RecipeType<?>, Map<Item, List<Ingredient>>> caches) {
        this.caches.clear();
        this.caches.putAll(caches);
    }

    public void setValidVesselItems(Set<Item> validVesselItems) {
        this.validVesselItems.clear();
        this.validVesselItems.addAll(validVesselItems);
    }

    public boolean isValidInput(ItemStack stack, RecipeType<?> type) {
        List cache = (List)this.caches.getOrDefault(type, Collections.emptyMap()).get(stack.getItem());
        return cache != null && cache.stream().anyMatch(i -> i.test(stack));
    }

    public boolean isValidSouliumSpawnerInput(ItemStack stack) {
        return this.isValidInput(stack.copyWithCount(Integer.MAX_VALUE), (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get());
    }

    public boolean isValidVesselItem(ItemStack stack) {
        return this.validVesselItems.contains(stack.getItem());
    }

    private static <C extends RecipeInput, T extends Recipe<C>> void cache(RecipeType<T> type) {
        RecipeIngredientCache.INSTANCE.caches.put(type, new HashMap());
        for (RecipeHolder recipe : RecipeHelper.byType(type)) {
            for (Ingredient ingredient : recipe.value().getIngredients()) {
                HashSet<Item> items = new HashSet<Item>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (items.contains(item)) continue;
                    List cache = RecipeIngredientCache.INSTANCE.caches.get(type).computeIfAbsent(item, i -> new ArrayList());
                    items.add(item);
                    cache.add(ingredient);
                }
            }
        }
    }

    private static void cacheVesselItems() {
        for (RecipeHolder recipe : RecipeHelper.byType((RecipeType)((RecipeType)ModRecipeTypes.AWAKENING.get()))) {
            for (ItemStack essence : ((IAwakeningRecipe)recipe.value()).getEssences()) {
                RecipeIngredientCache.INSTANCE.validVesselItems.add(essence.getItem());
            }
        }
    }
}

