/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.HexFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    private static final TagKey<EntityType<?>> BOSS_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"bosses"));

    private static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        HitResult pos = HealthBarRenderer.raycast(e, 32.0);
        Vec3 positionVector = e.getEyePosition();
        double distance = pos.getLocation().distanceTo(positionVector);
        Vec3 lookVector = e.getLookAngle();
        Vec3 reachVector = positionVector.add(lookVector.x * 32.0, lookVector.y * 32.0, lookVector.z * 32.0);
        List entitiesInBoundingBox = e.level().getEntities(e, e.getBoundingBox().inflate(lookVector.x * 32.0, lookVector.y * 32.0, lookVector.z * 32.0).expandTowards(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            Entity lookedEntity = null;
            if (entity.isPickable()) {
                double distanceToEntity;
                AABB collisionBox = entity.getBoundingBoxForCulling();
                Optional interceptPosition = collisionBox.clip(positionVector, reachVector);
                if (collisionBox.contains(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.distanceTo((Vec3)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance)) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static HitResult raycast(Entity e, double len) {
        Vec3 origin = e.getEyePosition();
        Vec3 ray = e.getLookAngle();
        Vec3 next = origin.add(ray.normalize().scale(len));
        return e.level().clip(new ClipContext(origin, next, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
    }

    private static ItemStack getIcon(LivingEntity entity, boolean boss) {
        if (boss) {
            return new ItemStack((ItemLike)Items.NETHER_STAR);
        }
        EntityType type = entity.getType();
        if (type.is(EntityTypeTags.ARTHROPOD)) {
            return new ItemStack((ItemLike)Items.SPIDER_EYE);
        }
        if (type.is(EntityTypeTags.UNDEAD)) {
            return new ItemStack((ItemLike)Items.ROTTEN_FLESH);
        }
        if (type.is(EntityTypeTags.ILLAGER)) {
            return new ItemStack((ItemLike)Items.IRON_AXE);
        }
        return ItemStack.EMPTY;
    }

    private static int getColor(LivingEntity entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            } else if (!entity.getType().getCategory().isFriendly()) {
                r = 255;
                g = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = Mth.clamp((float)entity.getHealth(), (float)0.0f, (float)entity.getMaxHealth());
        float hue = Math.max(0.0f, health / entity.getMaxHealth() / 3.0f - 0.07f);
        return Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f);
    }

    public static boolean isBoss(Entity entity) {
        return entity.getType().is(BOSS_TAG);
    }

    private static boolean shouldShowPlate(LivingEntity living, Entity cameraEntity) {
        Player cameraPlayer;
        if (living == cameraEntity) {
            return false;
        }
        if (!NeatConfig.instance.renderInF1() && !Minecraft.renderNames() || !NeatConfig.draw) {
            return false;
        }
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)living.getType());
        if (NeatConfig.instance.blacklist().contains(id.toString())) {
            return false;
        }
        float distance = living.distanceTo(cameraEntity);
        if (distance > (float)NeatConfig.instance.maxDistance() || distance > (float)NeatConfig.instance.maxDistanceWithoutLineOfSight() && !living.hasLineOfSight(cameraEntity)) {
            return false;
        }
        if (!NeatConfig.instance.showOnBosses() && HealthBarRenderer.isBoss((Entity)living)) {
            return false;
        }
        if (!NeatConfig.instance.showOnPlayers() && living instanceof Player) {
            return false;
        }
        if (!NeatConfig.instance.showFullHealth() && living.getHealth() >= living.getMaxHealth()) {
            return false;
        }
        if (NeatConfig.instance.showOnlyFocused() && HealthBarRenderer.getEntityLookedAt(cameraEntity) != living) {
            return false;
        }
        if (!NeatConfig.instance.showOnPassive() && living.getType().getCategory().isFriendly()) {
            return false;
        }
        if (!(NeatConfig.instance.showOnHostile() || living.getType().getCategory().isFriendly() || HealthBarRenderer.isBoss((Entity)living))) {
            return false;
        }
        if (living.hasPassenger(cameraEntity)) {
            return false;
        }
        boolean visible = true;
        if (cameraEntity instanceof Player && living.isInvisibleTo(cameraPlayer = (Player)cameraEntity)) {
            boolean wearingThings = false;
            for (ItemStack armorSlot : living.getArmorSlots()) {
                if (armorSlot.isEmpty()) continue;
                wearingThings = true;
            }
            for (ItemStack handSlot : living.getHandSlots()) {
                if (handSlot.isEmpty()) continue;
                wearingThings = true;
            }
            if (!wearingThings) {
                visible = false;
            }
        }
        PlayerTeam livingTeam = living.getTeam();
        PlayerTeam cameraTeam = cameraEntity.getTeam();
        if (livingTeam != null) {
            return switch (livingTeam.getNameTagVisibility()) {
                default -> throw new MatchException(null, null);
                case Team.Visibility.ALWAYS -> visible;
                case Team.Visibility.NEVER -> false;
                case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                    if (cameraTeam == null) {
                        yield visible;
                    }
                    if (livingTeam.isAlliedTo((Team)cameraTeam) && (livingTeam.canSeeFriendlyInvisibles() || visible)) {
                        yield true;
                    }
                    yield false;
                }
                case Team.Visibility.HIDE_FOR_OWN_TEAM -> cameraTeam == null ? visible : !livingTeam.isAlliedTo((Team)cameraTeam) && visible;
            };
        }
        return visible;
    }

    public static void hookRender(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Camera camera, EntityRenderer<? super Entity> entityRenderer, float partialTicks, double x, double y, double z) {
        int armor;
        Minecraft mc = Minecraft.getInstance();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!HealthBarRenderer.shouldShowPlate(living, camera.getEntity())) {
            return;
        }
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = NeatConfig.instance.barHeight();
        boolean boss = HealthBarRenderer.isBoss((Entity)living);
        String name = living.hasCustomName() ? String.valueOf(ChatFormatting.ITALIC) + living.getCustomName().getString() : living.getDisplayName().getString();
        float nameLen = (float)mc.font.width(name) * 0.5f;
        float halfSize = Math.max((float)NeatConfig.instance.plateSize(), nameLen / 2.0f + 10.0f);
        Vec3 vec3 = entityRenderer.getRenderOffset(entity, partialTicks);
        double d2 = x + vec3.x();
        double d3 = y + vec3.y();
        double d0 = z + vec3.z();
        poseStack.pushPose();
        poseStack.translate(d2, d3, d0);
        poseStack.translate(0.0, (double)living.getBbHeight() + NeatConfig.instance.heightAbove(), 0.0);
        poseStack.mulPose(camera.rotation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.pushPose();
        poseStack.scale(-0.0267f, -0.0267f, 0.0267f);
        if (NeatConfig.instance.drawBackground()) {
            float padding = NeatConfig.instance.backgroundPadding();
            int bgHeight = NeatConfig.instance.backgroundHeight();
            if (!NeatConfig.instance.showEntityName()) {
                bgHeight -= 4;
            }
            VertexConsumer builder = buffers.getBuffer(NeatRenderType.BAR_TEXTURE_TYPE);
            builder.addVertex(poseStack.last().pose(), -halfSize - padding, (float)(-bgHeight), 0.01f).setColor(0, 0, 0, 60).setUv(0.0f, 0.0f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), -halfSize - padding, (float)barHeight + padding, 0.01f).setColor(0, 0, 0, 60).setUv(0.0f, 0.5f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), halfSize + padding, (float)barHeight + padding, 0.01f).setColor(0, 0, 0, 60).setUv(1.0f, 0.5f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), halfSize + padding, (float)(-bgHeight), 0.01f).setColor(0, 0, 0, 60).setUv(1.0f, 0.0f).setLight(0xF000F0);
        }
        int argb = HealthBarRenderer.getColor(living, NeatConfig.instance.colorByType(), boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float maxHealth = Math.max(living.getHealth(), living.getMaxHealth());
        float healthHalfSize = halfSize * (living.getHealth() / maxHealth);
        VertexConsumer builder = buffers.getBuffer(NeatRenderType.BAR_TEXTURE_TYPE);
        builder.addVertex(poseStack.last().pose(), -halfSize, 0.0f, 0.001f).setColor(r, g, b, 127).setUv(0.0f, 0.75f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), -halfSize, (float)barHeight, 0.001f).setColor(r, g, b, 127).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).setColor(r, g, b, 127).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).setColor(r, g, b, 127).setUv(1.0f, 0.75f).setLight(0xF000F0);
        if (healthHalfSize < halfSize) {
            builder.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).setColor(0, 0, 0, 127).setUv(0.0f, 0.5f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).setColor(0, 0, 0, 127).setUv(0.0f, 0.75f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), halfSize, (float)barHeight, 0.001f).setColor(0, 0, 0, 127).setUv(1.0f, 0.75f).setLight(0xF000F0);
            builder.addVertex(poseStack.last().pose(), halfSize, 0.0f, 0.001f).setColor(0, 0, 0, 127).setUv(1.0f, 0.5f).setLight(0xF000F0);
        }
        int textColor = HexFormat.fromHexDigits(NeatConfig.instance.textColor());
        boolean black = false;
        if (NeatConfig.instance.showEntityName()) {
            poseStack.pushPose();
            poseStack.translate(-halfSize, -4.5f, 0.0f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            mc.font.drawInBatch(name, 0.0f, 0.0f, textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.popPose();
        }
        float healthValueTextScale = 0.375f;
        poseStack.pushPose();
        poseStack.translate(-halfSize, -4.5f, 0.0f);
        poseStack.scale(0.375f, 0.375f, 0.375f);
        int h = NeatConfig.instance.hpTextHeight();
        DecimalFormat health_format = new DecimalFormat(NeatConfig.instance.decimalFormat());
        if (NeatConfig.instance.showCurrentHP()) {
            String hpStr = health_format.format(living.getHealth());
            mc.font.drawInBatch(hpStr, 2.0f, (float)h, textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showMaxHP()) {
            String maxHpStr = String.valueOf(ChatFormatting.BOLD) + health_format.format(living.getMaxHealth());
            mc.font.drawInBatch(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - mc.font.width(maxHpStr) - 2), (float)h, textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showPercentage()) {
            String percStr = (int)(100.0f * living.getHealth() / living.getMaxHealth()) + "%";
            mc.font.drawInBatch(percStr, (float)((int)(halfSize / 0.375f)) - (float)mc.font.width(percStr) / 2.0f, (float)h, textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.enableDebugInfo() && mc.getDebugOverlay().showDebugScreen()) {
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)living.getType());
            mc.font.drawInBatch("ID: \"" + String.valueOf(id) + "\"", 0.0f, (float)(h + 16), textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
        poseStack.popPose();
        float zBump = -0.1f;
        poseStack.pushPose();
        float iconOffset = 2.85f;
        float zShift = 0.0f;
        if (NeatConfig.instance.showAttributes()) {
            ItemStack icon = HealthBarRenderer.getIcon(living, boss);
            HealthBarRenderer.renderIcon(living.level(), icon, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
            iconOffset += 5.0f;
            zShift += -0.1f;
        }
        if ((armor = living.getArmorValue()) > 0 && NeatConfig.instance.showArmor()) {
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.instance.groupArmor()) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            ItemStack iron = new ItemStack((ItemLike)Items.IRON_CHESTPLATE);
            for (int i = 0; i < ironArmor; ++i) {
                HealthBarRenderer.renderIcon(living.level(), iron, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
            ItemStack diamond = new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE);
            for (int i = 0; i < diamondArmor; ++i) {
                HealthBarRenderer.renderIcon(living.level(), diamond, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private static void renderIcon(Level level, ItemStack icon, PoseStack poseStack, MultiBufferSource buffers, float globalScale, float halfSize, float leftShift, float zShift) {
        if (!icon.isEmpty()) {
            float iconScale = 0.12f;
            poseStack.pushPose();
            double dx = (double)((halfSize - leftShift) * globalScale) + NeatConfig.instance.iconOffsetX();
            double dy = 3.0f * globalScale;
            double dz = zShift * globalScale;
            poseStack.translate(-dx, dy + NeatConfig.instance.iconOffsetY(), dz);
            poseStack.scale(0.12f, 0.12f, 0.12f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(icon, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, buffers, level, 0);
            poseStack.popPose();
        }
    }
}

