/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.compat.vanilla.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.potionstudios.biomeswevegone.compat.vanilla.dispenser.BWGBoatDispenseItemBehavior;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import org.jetbrains.annotations.NotNull;

public class BWGDispenseItemBehavior {
    public static void registerDispenseItemBehavior() {
        for (BWGBoatEntity.Type type : BWGBoatEntity.Type.values()) {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)type.getBoatItem().get()), (DispenseItemBehavior)new BWGBoatDispenseItemBehavior(type));
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)type.getChestBoatItem().get()), (DispenseItemBehavior)new BWGBoatDispenseItemBehavior(type, true));
        }
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BWGItems.MAN_O_WAR_BUCKET.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @NotNull
            protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)item.getItem();
                BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, blockPos, null)) {
                    dispensibleContainerItem.checkExtraContent(null, (Level)level, item, blockPos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultDispenseItemBehavior.dispense(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BWGBlocks.CARVED_PALE_PUMPKIN.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack item) {
                ServerLevel level = blockSource.level();
                BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                CarvedPumpkinBlock carvedPumpkinBlock = BWGBlocks.CARVED_PALE_PUMPKIN.get();
                if (level.isEmptyBlock(blockPos) && carvedPumpkinBlock.canSpawnGolem((LevelReader)level, blockPos)) {
                    if (!level.isClientSide()) {
                        level.setBlock(blockPos, carvedPumpkinBlock.defaultBlockState(), 3);
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
                    }
                    item.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor((BlockSource)blockSource, (ItemStack)item));
                }
                return item;
            }
        });
    }
}

