/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.treedecorators.BWGTreeDecorators;
import org.jetbrains.annotations.NotNull;

public class GlowBerryDecorator
extends TreeDecorator {
    public static final MapCodec<GlowBerryDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FloatProvider.CODEC.fieldOf("probability").forGetter(glowBerryDecorator -> glowBerryDecorator.probability), (App)IntProvider.CODEC.fieldOf("length").forGetter(glowBerryDecorator -> glowBerryDecorator.length), (App)FloatProvider.CODEC.fieldOf("berries_probability").forGetter(glowBerryDecorator -> glowBerryDecorator.berriesProbability)).apply((Applicative)instance, GlowBerryDecorator::new));
    private final FloatProvider probability;
    private final IntProvider length;
    private final FloatProvider berriesProbability;

    public GlowBerryDecorator(FloatProvider probability, IntProvider length, FloatProvider berriesProbability) {
        this.probability = probability;
        this.length = length;
        this.berriesProbability = berriesProbability;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return BWGTreeDecorators.GLOW_BERRY_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        float probability = this.probability.sample(random);
        int lengthSample = this.length.sample(random);
        float berriesProbability = this.berriesProbability.sample(random);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (BlockPos log : context.logs()) {
            if (!(random.nextFloat() < probability)) continue;
            mutable.set((Vec3i)log).move(Direction.DOWN);
            if (!context.isAir((BlockPos)mutable) || !context.isAir((BlockPos)mutable.move(Direction.DOWN))) continue;
            mutable.move(Direction.UP);
            boolean shouldBreak = false;
            for (int i = 1; i <= lengthSample; ++i) {
                BlockState state;
                if (context.isAir(mutable.offset(0, -1, 0)) && context.isAir(mutable.offset(0, -2, 0))) {
                    state = i == lengthSample ? Blocks.CAVE_VINES.defaultBlockState() : Blocks.CAVE_VINES_PLANT.defaultBlockState();
                } else {
                    state = Blocks.CAVE_VINES.defaultBlockState();
                    shouldBreak = true;
                }
                float chance = random.nextFloat();
                boolean value = chance < berriesProbability;
                state = (BlockState)state.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(value));
                if (state.hasProperty((Property)BlockStateProperties.AGE_25)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_25, (Comparable)Integer.valueOf(Mth.randomBetweenInclusive((RandomSource)random, (int)0, (int)25)));
                }
                context.setBlock((BlockPos)mutable, state);
                if (shouldBreak) continue block0;
                mutable.move(Direction.DOWN);
            }
        }
    }
}

