/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGCustomStructureProcessors;
import org.jetbrains.annotations.NotNull;

public class FruitBlockProcessor
extends StructureProcessor {
    public static final MapCodec<FruitBlockProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("fruit_block").forGetter(processor -> processor.fruitBlock)).apply((Applicative)instance, FruitBlockProcessor::new));
    private final BWGFruitBlock fruitBlock;

    public FruitBlockProcessor(BWGFruitBlock fruitBlock) {
        this.fruitBlock = fruitBlock;
    }

    private FruitBlockProcessor(Block fruitBlock) {
        this((BWGFruitBlock)fruitBlock);
    }

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(@NotNull ServerLevelAccessor serverLevel, @NotNull BlockPos offset, @NotNull BlockPos pos, @NotNull List<StructureTemplate.StructureBlockInfo> originalBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlockInfos, @NotNull StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> newInfo = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        processedBlockInfos.stream().filter(blockInfo -> blockInfo.state().is((Block)this.fruitBlock.getLeaves())).forEach(leavesBlockInfo -> {
            BlockPos fruitPos = leavesBlockInfo.pos().below();
            if (serverLevel.getBlockState(fruitPos).isAir() && serverLevel.getRandom().nextBoolean()) {
                newInfo.stream().filter(blockInfo -> blockInfo.pos().equals((Object)fruitPos)).findFirst().ifPresent(fruitSpot -> newInfo.set(newInfo.indexOf(fruitSpot), new StructureTemplate.StructureBlockInfo(fruitSpot.pos(), (BlockState)this.fruitBlock.defaultBlockState().setValue((Property)BWGFruitBlock.AGE, (Comparable)Integer.valueOf(serverLevel.getRandom().nextInt(3))), fruitSpot.nbt())));
            }
        });
        return newInfo;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return BWGCustomStructureProcessors.FRUIT_BLOCK_PROCESSOR.get();
    }
}

