/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeType;

public interface IPackageRecipeInfo {
    public static final Codec<IPackageRecipeInfo> CODEC = IPackageRecipeType.CODEC.dispatch("recipe_type", IPackageRecipeInfo::getRecipeType, IPackageRecipeType::getRecipeInfoMapCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IPackageRecipeInfo> STREAM_CODEC = IPackageRecipeType.STREAM_CODEC.cast().dispatch(IPackageRecipeInfo::getRecipeType, IPackageRecipeType::getRecipeInfoStreamCodec);

    public IPackageRecipeType getRecipeType();

    public boolean isValid();

    public List<IPackagePattern> getPatterns();

    default public List<IPackagePattern> getExtraPatterns() {
        return List.of();
    }

    public List<ItemStack> getInputs();

    public List<ItemStack> getOutputs();

    public Int2ObjectMap<ItemStack> getEncoderStacks();

    default public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (this.getRecipeType().hasCraftingRemainingItem()) {
            return stack.getCraftingRemainingItem();
        }
        return ItemStack.EMPTY;
    }

    default public boolean validPatternIndex(int index) {
        return index >= 0 && index < this.getPatterns().size();
    }

    default public boolean isPackageable() {
        return this.isValid() && !this.getInputs().isEmpty();
    }

    default public boolean isCraftable() {
        return this.isPackageable() && !this.getOutputs().isEmpty();
    }

    public boolean equals(Object var1);

    public int hashCode();
}

