/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.google.common.base.Functions;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.appeng.recipe.SimpleInput;

public class AppEngUtil {
    private static final Comparator<GenericStack> COMPARE_BY_STACKSIZE = (s1, s2) -> Long.compare(s1.amount(), s2.amount());

    private AppEngUtil() {
    }

    public static IInWorldGridNodeHost getAsInWorldGridNodeHost(BlockEntity blockEntity) {
        if (blockEntity instanceof IInWorldGridNodeHost) {
            IInWorldGridNodeHost inWorldGridNodeHost = (IInWorldGridNodeHost)blockEntity;
            return inWorldGridNodeHost;
        }
        return null;
    }

    public static List<GenericStack> condenseStacks(List<GenericStack> stacks) {
        List<GenericStack> merged = stacks.stream().filter(Objects::nonNull).collect(Collectors.toMap(GenericStack::what, Functions.identity(), GenericStack::sum, LinkedHashMap::new)).values().stream().toList();
        if (merged.size() == 0) {
            throw new IllegalStateException("No pattern here!");
        }
        return merged;
    }

    public static IPatternDetails.IInput[] toInputs(List<GenericStack> stacks, HolderLookup.Provider registries) {
        return AppEngUtil.toInputs(null, stacks, registries);
    }

    public static IPatternDetails.IInput[] toInputs(IPackageRecipeInfo recipe, List<GenericStack> stacks, HolderLookup.Provider registries) {
        IPatternDetails.IInput[] inputs = new IPatternDetails.IInput[stacks.size()];
        for (int i = 0; i < stacks.size(); ++i) {
            inputs[i] = new SimpleInput(recipe, stacks.get(i), registries);
        }
        return inputs;
    }

    public static GenericStack getGenericOutput(ItemStack stack, HolderLookup.Provider registries) {
        AEKey key;
        IVolumeStackWrapper vStack;
        if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && !(vStack = (IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).isEmpty() && vStack.getVolumeType() != null && vStack.getVolumeType().supportsAE() && (key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)vStack.saveAEKey(new CompoundTag(), registries))) != null) {
            return new GenericStack(key, (long)(vStack.getAmount() * stack.getCount()));
        }
        return GenericStack.fromItemStack((ItemStack)stack);
    }

    public static boolean isPatternProvider(BlockEntity blockEntity, Direction direction) {
        IPartHost partHost;
        return blockEntity instanceof PatternProviderLogicHost || blockEntity instanceof IPartHost && (partHost = (IPartHost)blockEntity).getPart(direction) instanceof PatternProviderLogicHost;
    }
}

