/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.CraftingProxyBlockEntity;

public class AECraftingProxyBlockEntity
extends CraftingProxyBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AECraftingProxyBlockEntity>,
IActionHost {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AECraftingProxyBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.level, this.worldPosition);
        }
        super.tick();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AECraftingProxyBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)this);
            this.gridNode.setTagName("Node");
            this.gridNode.setVisualRepresentation(PackagedAutoBlocks.CRAFTING_PROXY);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

