/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;

public class AEUnpackagerBlockEntity
extends UnpackagerBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEUnpackagerBlockEntity>,
IActionHost,
ICraftingProvider {
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEUnpackagerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.getMainNode().create(this.level, this.worldPosition);
        }
        super.tick();
        if (drawMEEnergy && !this.level.isClientSide && this.level.getGameTime() % (long)refreshInterval == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEUnpackagerBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public void onStateChanged(AEUnpackagerBlockEntity nodeOwner, IGridNode node, IGridNodeListener.State state) {
        if (state == IGridNodeListener.State.POWER || state == IGridNodeListener.State.CHANNEL) {
            this.postPatternChange();
        }
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)this);
            this.gridNode.setTagName("node");
            this.gridNode.setVisualRepresentation(PackagedAutoBlocks.UNPACKAGER);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridNode.addService(ICraftingProvider.class, (IGridNodeService)this);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (this.getMainNode().isActive() && !this.isBusy() && patternDetails instanceof RecipeCraftingPatternDetails) {
            RecipeCraftingPatternDetails pattern = (RecipeCraftingPatternDetails)patternDetails;
            int energyReq = energyUsage * pattern.recipe.getPatterns().size();
            if (this.energyStorage.getEnergyStored() >= energyReq) {
                UnpackagerBlockEntity.PackageTracker tracker = Arrays.stream(this.trackers).limit(this.trackerCount).filter(UnpackagerBlockEntity.PackageTracker::isEmpty).findFirst().get();
                tracker.fillRecipe(pattern.recipe);
                this.energyStorage.extractEnergy(energyReq, false);
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return Arrays.stream(this.trackers).limit(this.trackerCount).noneMatch(UnpackagerBlockEntity.PackageTracker::isEmpty);
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.getMainNode().isActive()) {
            RegistryAccess registry = this.level.registryAccess();
            return this.recipeList.stream().filter(IPackageRecipeInfo::isCraftable).map(pattern -> new RecipeCraftingPatternDetails((IPackageRecipeInfo)pattern, (HolderLookup.Provider)registry)).toList();
        }
        return List.of();
    }

    @Override
    public void postPatternChange() {
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    @Override
    protected boolean validSendTarget(BlockEntity blockEntity, Direction direction) {
        return super.validSendTarget(blockEntity, direction) && !AppEngUtil.isPatternProvider(blockEntity, direction);
    }

    protected void chargeMEEnergy() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnit.FE.convertTo(PowerUnit.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyService.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyService.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

