/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.stacks.AEItemKey;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.PatternType;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.appeng.recipe.DirectCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;
import thelm.packagedauto.util.MiscHelper;

public class PackagePatternDetailsDecoder
implements IPatternDetailsDecoder {
    public static final PackagePatternDetailsDecoder INSTANCE = new PackagePatternDetailsDecoder();

    protected PackagePatternDetailsDecoder() {
    }

    public boolean isEncodedPattern(ItemStack stack) {
        return MiscHelper.INSTANCE.isPackage(stack) && stack.has(PackagedAutoDataComponents.PATTERN_TYPE);
    }

    public IPatternDetails decodePattern(AEItemKey what, Level level) {
        return this.decodePattern(what.toStack(), level);
    }

    public IPatternDetails decodePattern(ItemStack what, Level level) {
        if (this.isEncodedPattern(what)) {
            switch ((PatternType)((Object)what.get(PackagedAutoDataComponents.PATTERN_TYPE))) {
                case PACKAGE: {
                    IPackageRecipeInfo recipe = (IPackageRecipeInfo)what.get(PackagedAutoDataComponents.RECIPE);
                    int index = (Integer)what.get(PackagedAutoDataComponents.PACKAGE_INDEX);
                    if (!recipe.isPackageable() || !recipe.validPatternIndex(index)) break;
                    return new PackageCraftingPatternDetails(recipe.getPatterns().get(index), (HolderLookup.Provider)level.registryAccess());
                }
                case RECIPE: {
                    IPackageRecipeInfo recipe = (IPackageRecipeInfo)what.get(PackagedAutoDataComponents.RECIPE);
                    if (!recipe.isCraftable()) break;
                    return new RecipeCraftingPatternDetails(recipe, (HolderLookup.Provider)level.registryAccess());
                }
                case DIRECT: {
                    IPackageRecipeInfo recipe = (IPackageRecipeInfo)what.get(PackagedAutoDataComponents.RECIPE);
                    if (!recipe.isCraftable()) break;
                    return new DirectCraftingPatternDetails(recipe, (HolderLookup.Provider)level.registryAccess());
                }
            }
        }
        return null;
    }
}

