/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;

public class SimpleInput
implements IPatternDetails.IInput {
    private final IPackageRecipeInfo recipe;
    private final GenericStack[] template;
    private final long multiplier;

    public SimpleInput(IPackageRecipeInfo recipe, GenericStack stack, HolderLookup.Provider registries) {
        this.recipe = recipe;
        this.template = new GenericStack[]{this.getGenericInput(stack, registries)};
        this.multiplier = stack.amount();
    }

    public GenericStack[] getPossibleInputs() {
        return this.template;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public boolean isValid(AEKey input, Level level) {
        return input.matches(this.template[0]);
    }

    public AEKey getRemainingKey(AEKey template) {
        if (this.recipe != null && this.recipe.getRecipeType().hasCraftingRemainingItem() && template instanceof AEItemKey) {
            AEItemKey itemTemplate = (AEItemKey)template;
            return AEItemKey.of((ItemStack)this.recipe.getCraftingRemainingItem(itemTemplate.toStack()));
        }
        return null;
    }

    private GenericStack getGenericInput(GenericStack stack, HolderLookup.Provider registries) {
        AEKey key;
        IVolumeStackWrapper vStack;
        AEItemKey itemKey;
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEItemKey && (itemKey = (AEItemKey)aEKey).toStack().has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && !(vStack = (IVolumeStackWrapper)itemKey.toStack().get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).isEmpty() && vStack.getVolumeType().supportsAE() && (key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)vStack.saveAEKey(new CompoundTag(), registries))) != null) {
            return new GenericStack(key, (long)vStack.getAmount());
        }
        return new GenericStack(stack.what(), 1L);
    }
}

