/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packagedauto.block.entity.BaseBlockEntity;

public record SyncEnergyPacket(BlockPos pos, int energy) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncEnergyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packagedauto:sync_energy"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncEnergyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncEnergyPacket::pos, (StreamCodec)ByteBufCodecs.INT, SyncEnergyPacket::energy, SyncEnergyPacket::new);

    public CustomPacketPayload.Type<SyncEnergyPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity be;
            ClientLevel level = Minecraft.getInstance().level;
            if (level.isLoaded(this.pos) && (be = level.getBlockEntity(this.pos)) instanceof BaseBlockEntity) {
                BaseBlockEntity bbe = (BaseBlockEntity)be;
                bbe.getEnergyStorage().setEnergyStored(this.energy);
            }
        });
    }

    public static void syncEnergy(ServerLevel level, BlockPos pos, int energy, double range) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)range, (CustomPacketPayload)new SyncEnergyPacket(pos, energy), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

