/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.OrderedProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class OrderedProcessingPackageRecipeInfo
implements IPackageRecipeInfo {
    public static final MapCodec<OrderedProcessingPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(81).fieldOf("input").forGetter(IPackageRecipeInfo::getInputs), (App)MiscHelper.LARGE_ITEM_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(9).fieldOf("output").forGetter(IPackageRecipeInfo::getOutputs)).apply((Applicative)instance, OrderedProcessingPackageRecipeInfo::new));
    public static final Codec<OrderedProcessingPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, OrderedProcessingPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, IPackageRecipeInfo::getInputs, (StreamCodec)ItemStack.LIST_STREAM_CODEC, IPackageRecipeInfo::getOutputs, OrderedProcessingPackageRecipeInfo::new);
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public OrderedProcessingPackageRecipeInfo(List<ItemStack> inputs, List<ItemStack> outputs) {
        this.input = OrderedProcessingPackageRecipeInfo.removeEmptyStacks(inputs);
        this.output = MiscHelper.INSTANCE.condenseStacks(outputs, true);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    private static List<ItemStack> removeEmptyStacks(List<ItemStack> stacks) {
        return stacks.stream().filter(stack -> !stack.isEmpty()).toList();
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return OrderedProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderedProcessingPackageRecipeInfo) {
            OrderedProcessingPackageRecipeInfo other = (OrderedProcessingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, null);
    }
}

