/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class ProcessingPackageRecipeInfo
implements IPackageRecipeInfo {
    public static final MapCodec<ProcessingPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(81).fieldOf("input").forGetter(IPackageRecipeInfo::getInputs), (App)MiscHelper.LARGE_ITEM_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(9).fieldOf("output").forGetter(IPackageRecipeInfo::getOutputs)).apply((Applicative)instance, ProcessingPackageRecipeInfo::new));
    public static final Codec<ProcessingPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, ProcessingPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, IPackageRecipeInfo::getInputs, (StreamCodec)ItemStack.LIST_STREAM_CODEC, IPackageRecipeInfo::getOutputs, ProcessingPackageRecipeInfo::new);
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public ProcessingPackageRecipeInfo(List<ItemStack> inputs, List<ItemStack> outputs) {
        this.input = MiscHelper.INSTANCE.condenseStacks(inputs);
        this.output = MiscHelper.INSTANCE.condenseStacks(outputs, true);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return ProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProcessingPackageRecipeInfo) {
            ProcessingPackageRecipeInfo other = (ProcessingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, null);
    }
}

