/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.volume;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.neoforged.neoforge.fluids.FluidStack;
import thelm.packagedauto.api.IFluidStackWrapper;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.volume.FluidVolumeType;

public record FluidStackWrapper(FluidStack stack) implements IFluidStackWrapper
{
    public static final FluidStackWrapper EMPTY = new FluidStackWrapper(FluidStack.EMPTY);
    public static final Codec<FluidStackWrapper> CODEC = FluidStack.CODEC.xmap(FluidStackWrapper::of, FluidStackWrapper::getFluid);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStackWrapper> STREAM_CODEC = FluidStack.STREAM_CODEC.map(FluidStackWrapper::of, FluidStackWrapper::getFluid);

    public static FluidStackWrapper of(FluidStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new FluidStackWrapper(stack);
    }

    @Override
    public IVolumeType getVolumeType() {
        return FluidVolumeType.INSTANCE;
    }

    @Override
    public FluidStack getFluid() {
        return this.stack;
    }

    @Override
    public int getAmount() {
        return this.stack.getAmount();
    }

    @Override
    public IVolumeStackWrapper copy() {
        return new FluidStackWrapper(this.stack.copy());
    }

    @Override
    public IVolumeStackWrapper withAmount(int amount) {
        return new FluidStackWrapper(this.stack.copyWithAmount(amount));
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public CompoundTag saveAEKey(CompoundTag tag, HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        tag.putString("#t", "ae2:f");
        tag.putString("id", BuiltInRegistries.FLUID.getKey((Object)this.stack.getFluid()).toString());
        if (!this.stack.isComponentsPatchEmpty()) {
            tag.put("components", (Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)ops, (Object)this.stack.getComponentsPatch()).getOrThrow());
        }
        return tag;
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getHoverName();
    }

    @Override
    public Component getAmountDesc() {
        return Component.literal((String)(this.stack.getAmount() + "mB"));
    }

    @Override
    public List<Component> getTooltip() {
        return List.of(this.stack.getHoverName());
    }

    @Override
    public int hashCode() {
        return FluidStack.hashFluidAndComponents((FluidStack)this.stack);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FluidStackWrapper) {
            FluidStackWrapper other = (FluidStackWrapper)obj;
            return FluidStack.matches((FluidStack)this.stack, (FluidStack)other.stack);
        }
        return false;
    }
}

