/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.widget;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.client.screen.Texture;

public class IconButton
extends Button {
    protected final Minecraft mc = Minecraft.getInstance();
    @Nullable
    private Supplier<List<Component>> tooltipSupplier;
    private Screen screen;
    private Texture texture;
    private Texture hovering;
    private ItemStack stack;
    private float xOffset;
    private float yOffset;
    @Nullable
    private SoundEvent sound;
    public static final IconButton EMPTY = new IconButton(0, 0, Texture.EMPTY, b -> {}, (Screen)new ChatScreen(""));

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.EMPTY, texture, Texture.EMPTY, text, onPress, screen);
    }

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Texture hovering, Screen screen) {
        this(x, y, ItemStack.EMPTY, texture, hovering, text, onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.EMPTY, texture, Texture.EMPTY, (Component)Component.empty(), onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.EMPTY, texture, hovering, (Component)Component.empty(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, Texture.EMPTY, (Component)Component.empty(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, hovering, (Component)Component.empty(), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Component text, Button.OnPress onPress, Screen screen) {
        super(x, y, texture.getWidth(), texture.getHeight(), text, onPress, DEFAULT_NARRATION);
        this.texture = texture;
        this.screen = screen;
        this.hovering = hovering;
        this.stack = stack;
    }

    protected void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float pt) {
        if (this.isHovered && this.tooltipSupplier != null) {
            this.setTooltip(this.createTooltip());
        }
        if (this.isHovered && !this.hovering.isEmpty()) {
            this.hovering.draw(gui, this.getX(), this.getY());
        } else {
            this.texture.draw(gui, this.getX(), this.getY());
        }
        Font f = this.mc.font;
        String s = this.getMessage().getString();
        if (!s.isEmpty()) {
            int width = f.width(s);
            TextColor c = this.getMessage().getStyle().getColor();
            int color = c == null ? 0x555555 : c.getValue();
            gui.drawString(f, s, Math.round(this.xOffset + (float)this.getX() + 0.5f + (float)this.width / 2.0f - (float)width / 2.0f), Math.round(this.yOffset + (float)this.getY() + (float)this.height / 2.0f - 4.0f), color, false);
        }
        if (!this.stack.isEmpty()) {
            int x = (int)Math.round((double)(this.xOffset + (float)this.getX()) - 8.0 + (double)((float)this.width / 2.0f));
            int y = (int)Math.round((double)(this.yOffset + (float)this.getY()) - 8.0 + (double)((float)this.height / 2.0f));
            gui.renderFakeItem(this.stack, x, y);
            gui.renderItemDecorations(f, this.stack, x, y);
        }
    }

    @Nullable
    private Tooltip createTooltip() {
        if (this.tooltipSupplier == null) {
            return null;
        }
        return this.tooltipSupplier.get().stream().reduce((component, component2) -> component.copy().append("\n").append(component2)).map(Tooltip::create).orElse(null);
    }

    public void blit(GuiGraphics gui, Texture texture, int x, int y) {
        gui.blit(texture.getLocation(), x, y, texture.getU(), texture.getV(), texture.getWidth(), texture.getHeight());
    }

    public Screen getScreen() {
        return this.screen;
    }

    public IconButton setScreen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public IconButton setTexture(Texture texture) {
        this.texture = texture;
        return this;
    }

    public Texture getHovering() {
        return this.hovering;
    }

    public IconButton setHovering(Texture hovering) {
        this.hovering = hovering;
        return this;
    }

    public IconButton setTooltip(Component component) {
        super.setTooltip(Tooltip.create((Component)component));
        return this;
    }

    public IconButton setTooltipSupplier(Supplier<List<Component>> supplier) {
        this.tooltipSupplier = supplier;
        return this;
    }

    public IconButton setStackInSlot(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public IconButton xOffset(float xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public IconButton yOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public void playDownSound(SoundManager handler) {
        if (this.sound != null) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.sound, (float)1.0f));
        }
    }

    public IconButton setClickSound() {
        this.sound = (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value();
        return this;
    }

    public IconButton setSound(@Nullable SoundEvent sound) {
        this.sound = sound;
        return this;
    }
}

