/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.blockentity;

import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.client.particles.MagicAuraParticleData;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HealerStandingStone
extends BEBase {
    private static final int RADIUS = 10;
    private static final int PTN_SECONDS = 25;
    private int ticker = 0;

    public HealerStandingStone(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public HealerStandingStone(BlockPos pos, BlockState state) {
        this((BlockEntityType)RootsRegistry.HEALER_STANDING_STONE_TILE.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HealerStandingStone tile) {
        ++tile.ticker;
        if (tile.ticker % 20 == 0) {
            List nearbyCreatures = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)(pos.getX() - 10), (double)(pos.getY() - 10), (double)(pos.getZ() - 10), (double)(pos.getX() + 10), (double)(pos.getY() + 10), (double)(pos.getZ() + 10)));
            for (LivingEntity nearbyCreature : nearbyCreatures) {
                nearbyCreature.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 500, 1));
            }
        }
        if (tile.ticker >= 2000) {
            tile.ticker = 0;
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HealerStandingStone tile) {
        ++tile.ticker;
        if (tile.ticker % 5 == 0 && level.isClientSide) {
            for (double i = 0.0; i < 720.0; i += 45.0) {
                double xShift = 0.5 * Math.sin(Math.PI * (i / 360.0));
                double zShift = 0.5 * Math.cos(Math.PI * (i / 360.0));
                level.addParticle(MagicAuraParticleData.createData(255.0, 32.0, 32.0), (double)pos.getX() + 0.5 + xShift, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + zShift, 0.0, 0.0, 0.0);
            }
        }
        if (tile.ticker >= 2000) {
            tile.ticker = 0;
        }
    }
}

