/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.mojang.serialization.DynamicOps;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.datacomponent.StatueUpgrades;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.storage.StatueSavedData;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractStatueBlockEntity
extends BlockEntity {
    private final Map<String, Short> upgrades = new HashMap<String, Short>();
    protected EnergyStorage energyStorage = new EnergyStorage(10000, 100);
    @Nullable
    private StatueStats stats = StatueStats.empty();
    public int cooldown;
    public int interactCooldown;
    public boolean statueAble;
    public boolean statueInteractable;
    public boolean statueUpgraded;
    public static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    protected AbstractStatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
        this.cooldown = (Integer)StatuesConfig.COMMON.statueCooldown.get();
        this.interactCooldown = (Integer)StatuesConfig.COMMON.statueCooldown.get();
        this.statueAble = false;
        this.statueInteractable = false;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        Tag tag;
        super.loadAdditional(compound, provider);
        this.cooldown = compound.getInt("StatueCooldown");
        this.interactCooldown = compound.getInt("InteractionCooldown");
        this.statueAble = compound.getBoolean("StatueAble");
        this.statueInteractable = compound.getBoolean("StatueInteractable");
        if (compound.contains("EnergyHandler") && (tag = compound.get("EnergyHandler")) instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(provider, (Tag)intTag);
        }
        this.loadFromNbt(compound, provider);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("StatueCooldown", this.cooldown);
        compound.putInt("InteractionCooldown", this.interactCooldown);
        compound.putBoolean("StatueAble", this.statueAble);
        compound.putBoolean("StatueInteractable", this.statueInteractable);
        compound.put("EnergyHandler", this.energyStorage.serializeNBT(provider));
        this.saveToNbt(compound, provider);
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider provider) {
        stack.set(StatueDataComponents.STATS, (Object)this.stats);
        stack.set(StatueDataComponents.UPGRADED, (Object)true);
        stack.set(StatueDataComponents.UPGRADES, (Object)new StatueUpgrades(this.upgrades));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.stats = (StatueStats)input.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
        Map<String, Short> upgradeMap = ((StatueUpgrades)input.getOrDefault(StatueDataComponents.UPGRADES, (Object)StatueUpgrades.empty())).upgradeMap();
        if (!upgradeMap.isEmpty()) {
            this.upgrades.putAll(upgradeMap);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(StatueDataComponents.UPGRADES, (Object)new StatueUpgrades(this.upgrades));
        builder.set(StatueDataComponents.STATS, (Object)this.stats);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("tag");
        tag.remove("stats");
        tag.remove("EnergyHandler");
    }

    public EnergyStorage getEnergyStorage(@Nullable Direction facing) {
        if (((Boolean)StatuesConfig.COMMON.requiresPower.get()).booleanValue()) {
            return this.energyStorage;
        }
        return null;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && this.isDespawner()) {
            StatueSavedData.get().addPosition((ResourceKey<Level>)this.level.dimension(), this.getBlockPos());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && this.isDespawner()) {
            StatueSavedData.get().removePosition((ResourceKey<Level>)this.level.dimension(), this.getBlockPos());
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
        BlockState state = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)(this.level != null ? this.level.registryAccess() : VanillaRegistries.createLookup()));
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getCooldown() {
        return Math.max((Integer)StatuesConfig.COMMON.statueMinCooldown.get(), (Integer)StatuesConfig.COMMON.statueCooldown.get() - this.getSpeedTicks());
    }

    public int getInteractCooldown() {
        return Math.max((Integer)StatuesConfig.COMMON.statueMinCooldown.get(), (Integer)StatuesConfig.COMMON.statueCooldown.get() - this.getSpeedTicks());
    }

    public int getSpeedTicks() {
        return this.getSpeed() * (Integer)StatuesConfig.COMMON.statueSpeedUpgrade.get();
    }

    public int getStatueLevel() {
        return this.stats != null ? this.stats.level() : -1;
    }

    public int getUpgradeSlots() {
        return this.stats != null ? this.stats.upgradeSlots() : -1;
    }

    public int getKillCount() {
        return this.stats != null ? this.stats.killCount() : -1;
    }

    public boolean isStatueAble() {
        return this.statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        this.statueAble = statueAble;
        this.setChanged();
    }

    public boolean isStatueInteractable() {
        return this.statueInteractable;
    }

    public void setStatueInteractable(boolean interactable) {
        this.statueInteractable = interactable;
        this.setChanged();
    }

    public void loadFromNbt(CompoundTag compound, HolderLookup.Provider provider) {
        this.statueUpgraded = compound.getBoolean("statueUpgraded");
        if (compound.contains("upgrades")) {
            StatueUpgrades.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("upgrades")).resultOrPartial(error -> Statues.LOGGER.error("Failed to load upgrades from statue: {}", error)).ifPresent(upgrades -> {
                this.upgrades.clear();
                this.upgrades.putAll(upgrades.upgradeMap());
            });
        }
        if (compound.contains("stats")) {
            StatueStats.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("stats")).resultOrPartial(error -> Statues.LOGGER.error("Failed to load stats from statue: {}", error)).ifPresent(this::setStats);
        }
    }

    public void setStats(StatueStats stats) {
        this.stats = stats;
    }

    public CompoundTag saveToNbt(CompoundTag compound, HolderLookup.Provider provider) {
        this.saveUpgrades(compound, provider);
        if (this.upgrades != null) {
            StatueUpgrades.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new StatueUpgrades(this.upgrades)).resultOrPartial(arg_0 -> ((Logger)Statues.LOGGER).error(arg_0)).ifPresent(upgrades -> compound.put("upgrades", upgrades));
        }
        if (this.stats != null) {
            StatueStats.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stats).resultOrPartial(arg_0 -> ((Logger)Statues.LOGGER).error(arg_0)).ifPresent(stats -> compound.put("stats", stats));
        }
        return compound;
    }

    public CompoundTag saveUpgrades(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("statueUpgraded", this.statueUpgraded);
        return tag;
    }

    protected void refreshClient() {
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
    }

    public Map<String, Short> getUpgrades() {
        return this.upgrades;
    }

    public boolean isDecorative() {
        return !this.getUpgrades().isEmpty();
    }

    public boolean hasUpgrade(String id) {
        return this.getUpgrades().containsKey(id);
    }

    public int getUpgradeLevel(String id) {
        return this.getUpgrades().getOrDefault(id, (short)-1).shortValue();
    }

    public boolean makesSounds() {
        return this.hasUpgrade("sound");
    }

    public boolean isSpawner() {
        return this.hasUpgrade("spawner");
    }

    public boolean isKiller() {
        return this.hasUpgrade("mob_killer");
    }

    public boolean isDespawner() {
        return this.hasUpgrade("despawner");
    }

    public int getSpawnerLevel() {
        return this.getUpgradeLevel("spawner");
    }

    public boolean hasSpecialInteraction() {
        return this.hasUpgrade("interaction");
    }

    public boolean canDropLoot() {
        return this.hasUpgrade("looting");
    }

    public int getLooting() {
        return this.getUpgradeLevel("looting") - 1;
    }

    public boolean canAutomate() {
        return this.hasUpgrade("automation");
    }

    public int getSpeed() {
        return this.hasUpgrade("speed") ? this.getUpgradeLevel("speed") + 1 : 0;
    }

    private int getAdjustedPower(int power) {
        return Mth.ceil((double)((double)power * (this.canAutomate() ? 1.2 : 1.0)));
    }

    public int getItemPowerUsage() {
        double lootingMultiplier = switch (this.getLooting()) {
            case 2 -> 1.25;
            case 3 -> 1.5;
            default -> 1.0;
        };
        int amount = (Integer)StatuesConfig.COMMON.itemPowerUsage.get();
        if (amount == 0) {
            return 0;
        }
        return this.getAdjustedPower(Mth.ceil((double)((double)amount * lootingMultiplier)));
    }

    public int getKillPowerUsage() {
        int amount = (Integer)StatuesConfig.COMMON.killPowerUsage.get();
        if (amount == 0) {
            return 0;
        }
        return this.getAdjustedPower(amount);
    }

    public int getSummonPowerUsage() {
        return (Integer)StatuesConfig.COMMON.summonPowerUsage.get();
    }

    public int getDespawnPowerUsage() {
        return (Integer)StatuesConfig.COMMON.despawnPowerUsage.get();
    }

    public int getPassiveDrain() {
        return 100;
    }

    public boolean usesPower() {
        return (Boolean)StatuesConfig.COMMON.requiresPower.get();
    }

    public boolean drainPower(int amount) {
        if (this.usesPower() && amount > 0) {
            boolean hasEnergy;
            boolean bl = hasEnergy = this.energyStorage.getEnergyStored() >= amount;
            if (!hasEnergy) {
                return false;
            }
            this.energyStorage.extractEnergy(amount, false);
        }
        return true;
    }

    public ItemInteractionResult interact(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public AbstractStatueBase getStatue() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof AbstractStatueBase) {
            AbstractStatueBase statueBase = (AbstractStatueBase)block;
            return statueBase;
        }
        return null;
    }

    public void playSound(SoundEvent sound, BlockPos pos) {
        this.playSound(sound, pos, 1.0f);
    }

    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        this.level.playSound(null, pos, sound, SoundSource.NEUTRAL, 1.0f, pitch);
    }

    public ItemStack getFirework(RandomSource rand) {
        ItemStack firework = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DYE_COLORS[rand.nextInt(16)];
        }
        IntList colorList = IntList.of((int[])colors);
        int type = rand.nextInt(3) + 1;
        type = type == 3 ? 4 : (int)type;
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.byId((int)type), colorList, IntList.of(), true, true);
        explosions.add(explosion);
        Fireworks fireworks = new Fireworks(1, explosions);
        firework.set(DataComponents.FIREWORKS, (Object)fireworks);
        return firework;
    }

    protected class BiggestInventory
    implements Comparable<BiggestInventory> {
        private final int inventorySize;
        private final BlockPos tilePos;
        private final Direction direction;

        public BiggestInventory(BlockPos pos, int size, Direction dir) {
            this.tilePos = pos;
            this.inventorySize = size;
            this.direction = dir;
        }

        protected IItemHandler getIItemHandler(ServerLevel level) {
            if (level.isAreaLoaded(AbstractStatueBlockEntity.this.worldPosition, 1)) {
                BlockEntity blockEntity = level.getBlockEntity(this.tilePos);
                BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)this.tilePos, (Object)this.direction);
                if (!blockEntity.isRemoved() && blockEntity.hasLevel() && cache.getCapability() != null) {
                    return (IItemHandler)cache.getCapability();
                }
            }
            return null;
        }

        @Override
        public int compareTo(BiggestInventory otherInventory) {
            return Integer.compare(this.inventorySize, otherInventory.inventorySize);
        }
    }
}

