/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.registry.StatueBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class TropicalFishBlockEntity
extends StatueBlockEntity {
    private int MAIN_COLOR = 0;
    private int SECONDARY_COLOR = 0;

    public TropicalFishBlockEntity(BlockPos pos, BlockState state) {
        super(StatueBlockEntities.TROPICAL_FISH.get(), pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.MAIN_COLOR = compound.getInt("MainColor");
        this.SECONDARY_COLOR = compound.getInt("SecondaryColor");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("MainColor", this.MAIN_COLOR);
        compound.putInt("SecondaryColor", this.SECONDARY_COLOR);
    }

    public void scrambleColors() {
        if (this.level != null) {
            this.MAIN_COLOR = this.level.random.nextInt(16);
            this.SECONDARY_COLOR = this.level.random.nextInt(16);
        }
        this.setChanged();
    }

    public int getMainColor() {
        return this.MAIN_COLOR;
    }

    public int getSecondaryColor() {
        return this.SECONDARY_COLOR;
    }
}

