/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks;

import com.mojang.serialization.MapCodec;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoreFlowerCropBlock
extends CropBlock {
    public static final MapCodec<TorchflowerCropBlock> CODEC = CoreFlowerCropBlock.simpleCodec(TorchflowerCropBlock::new);
    public static final int MAX_AGE = 8;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)8);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)};

    public MapCodec<TorchflowerCropBlock> codec() {
        return CODEC;
    }

    public CoreFlowerCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 8;
    }

    protected ItemLike getBaseSeedId() {
        return Items.TORCHFLOWER_SEEDS;
    }

    public BlockState getStateForAge(int age) {
        return age == 8 ? ((FlowerBlock)StatueRegistry.CORE_FLOWER.get()).defaultBlockState() : super.getStateForAge(age);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(3) != 0) {
            super.randomTick(state, level, pos, random);
        }
    }

    protected int getBonemealAgeIncrease(Level level) {
        return 1;
    }
}

