/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.decorative;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.blocks.decorative.BumboStatueBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SombreroBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public SombreroBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Block block = level.getBlockState(pos.below()).getBlock();
        if (block == Blocks.CACTUS && placer != null) {
            BlockPos downPos = pos.below();
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)downPos.getX(), (double)downPos.getY(), (double)downPos.getZ(), 1.0, 0.0, 0.0);
            BlockState bumboState = (BlockState)((BumboStatueBlock)StatueRegistry.BUMBO_STATUE.get()).defaultBlockState().setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
            level.setBlockAndUpdate(pos.below(), bumboState);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player playerIn, BlockHitResult result) {
        if (!level.isClientSide && this.canPlaySound(level, pos, state)) {
            level.playSound(null, pos, SoundEvents.ANVIL_LAND, SoundSource.NEUTRAL, 1.0f, this.getPitch());
        }
        return InteractionResult.SUCCESS;
    }

    public float getPitch() {
        return (RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean canPlaySound(Level level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.below()).getBlock() instanceof NoteBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

