/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.registry.StatueSounds;
import com.shynieke.statues.util.ListHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CampfireStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0);
    public static final List<Supplier<SoundEvent>> campfire_sounds = ImmutableList.of(StatueSounds.CAMPFIRE_BYE_RANDOM, StatueSounds.CAMPFIRE_COLD_RANDOM, StatueSounds.CAMPFIRE_GREETINGS_RANDOM, StatueSounds.CAMPFIRE_HELLO_RANDOM, StatueSounds.CAMPFIRE_SNACKS_RANDOM);

    public CampfireStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE).lightLevel(state -> 12));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return CampfireStatueBlock.getRandomCampfire();
    }

    @Override
    public LivingEntity adjustSpawnedEntity(LivingEntity livingEntity) {
        if (livingEntity instanceof Creeper) {
            Creeper general = (Creeper)livingEntity;
            general.setCustomName((Component)Component.literal((String)"General Spazz"));
            CompoundTag tag = new CompoundTag();
            tag.putByte("ExplosionRadius", (byte)0);
            general.addAdditionalSaveData(tag);
            return general;
        }
        return livingEntity;
    }

    public static SoundEvent getRandomCampfire() {
        return ListHelper.getRandomFromList(campfire_sounds).get();
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.CREEPER;
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

