/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.compat.patchouli.PatchouliCompat;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueTags;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;

public class InfoStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.5, (double)13.0);
    private static final VoxelShape TOP_SHAPE = Block.box((double)5.5, (double)4.5, (double)5.5, (double)10.5, (double)7.0, (double)10.5);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);

    public InfoStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.is(Items.BOOK) && ModList.get().isLoaded("patchouli")) {
                PatchouliCompat.convertBook(player);
                return ItemInteractionResult.SUCCESS;
            }
            if (heldItem.is(Items.PAPER) && !(player instanceof FakePlayer) && player.getGameProfile().getId().equals(UUID.fromString("7135da42-d327-47bb-bb04-5ba4e212fb32"))) {
                if (!level.isClientSide) {
                    player.sendSystemMessage((Component)Component.literal((String)"Statues version: ").append((Component)Component.literal((String)ModList.get().getModFileById("statues").versionString())).withStyle(ChatFormatting.GOLD));
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (heldItem.is(StatueTags.UPGRADEABLE_STATUES) && !(player instanceof FakePlayer) && this.upgraded(heldItem)) {
                BlockItem blockItem;
                Item item = heldItem.getItem();
                if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractStatueBase) {
                    AbstractStatueBase statueBase = (AbstractStatueBase)item;
                    if (!level.isClientSide) {
                        player.sendSystemMessage((Component)Component.literal((String)"To level this statue you need to kill ").append((Component)Component.translatable((String)statueBase.getEntity().getDescriptionId()).withStyle(ChatFormatting.GOLD)));
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            this.sendInfoMessage(player, level, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private boolean upgraded(ItemStack stack) {
        return (Boolean)stack.getOrDefault(StatueDataComponents.UPGRADED, (Object)false);
    }

    public void sendInfoMessage(Player player, Level level, BlockPos pos) {
        if (!level.isClientSide) {
            int random = level.random.nextInt(100);
            ArrayList<String> messages = new ArrayList<String>((Collection)StatuesConfig.COMMON.info_messages.get());
            List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
            if (ModList.get().isLoaded("veinminer")) {
                messages.add("Did you know we have veinminer");
            }
            if (ModList.get().isLoaded("curios")) {
                messages.add("Did you know we have curios support");
            }
            int idx = new Random().nextInt(messages.size());
            MutableComponent randomMessage = Component.literal((String)((String)messages.get(idx)));
            if (!luckyPlayers.isEmpty() && random < 20) {
                for (String luckyPlayer : luckyPlayers) {
                    if (luckyPlayer.isEmpty()) continue;
                    String luckyUser = luckyPlayer.trim();
                    if (!player.getDisplayName().getString().equalsIgnoreCase(luckyUser)) continue;
                    randomMessage = Component.literal((String)"Luck is not on your side today");
                }
            } else {
                LocalDate localdate = LocalDate.now();
                int i = localdate.getDayOfMonth();
                int j = localdate.getMonthValue();
                randomMessage = level.random.nextDouble() <= 0.3 && j == 11 && i <= 20 ? Component.literal((String)"Please check out our friends over at ").withStyle(ChatFormatting.YELLOW).append(CommonHooks.newChatWithLinks((String)"https://lovetropics.com/")) : Component.literal((String)((String)messages.get(idx)));
            }
            player.sendSystemMessage((Component)randomMessage);
            level.playSound(null, pos, SoundEvents.DISPENSER_FAIL, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

