/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues.fish;

import com.shynieke.statues.blocks.AbstractStatueBase;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PufferfishStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE_MEDIUM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape SHAPE_BIG = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private final int size;

    public PufferfishStatueBlock(BlockBehaviour.Properties builder, int size) {
        super(builder.sound(SoundType.STONE));
        this.size = size;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (this.size) {
            default -> SHAPE;
            case 1 -> SHAPE_MEDIUM;
            case 2 -> SHAPE_BIG;
        };
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.PUFFERFISH;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.PUFFER_FISH_BLOW_UP;
    }
}

