/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.statues.fish.FishStatueBlock;
import com.shynieke.statues.client.SupporterType;
import com.shynieke.statues.client.ber.StatueTableBER;
import com.shynieke.statues.client.model.PlayerStatueModel;
import com.shynieke.statues.client.render.PlayerBER;
import com.shynieke.statues.client.render.PlayerStatueRenderer;
import com.shynieke.statues.client.render.StatueBatRenderer;
import com.shynieke.statues.client.screen.ShulkerStatueScreen;
import com.shynieke.statues.client.screen.StatueTableScreen;
import com.shynieke.statues.compat.curios.client.StatueCurioRenderer;
import com.shynieke.statues.datacomponent.PlayerCompassData;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Services;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import org.jetbrains.annotations.Nullable;

public class ClientHandler {
    public static final ModelLayerLocation PLAYER_STATUE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"player_statue"), "player_statue");
    public static final ModelLayerLocation PLAYER_STATUE_SLIM = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"player_statue_slim"), "player_statue_slim");
    public static final List<UUID> SUPPORTER = new ArrayList<UUID>();
    public static final List<UUID> TRANSLATORS = new ArrayList<UUID>();

    public static void doClientStuff(FMLClientSetupEvent event) {
        ClientHandler.setPlayerCache(Minecraft.getInstance());
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)StatueRegistry.PLAYER_COMPASS.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private final Angle rotation = new Angle();
            private final Angle rota = new Angle();

            public float unclampedCall(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entityIn, int p_174567_) {
                LivingEntity entity;
                Object object = entity = entityIn != null ? entityIn : stack.getEntityRepresentation();
                if (entity == null) {
                    return 0.0f;
                }
                if (level == null && entity.level() instanceof ClientLevel) {
                    level = (ClientLevel)entity.level();
                }
                if (level != null) {
                    BlockPos blockpos = this.getWorldPos(level);
                    long gameTime = level.getGameTime();
                    PlayerCompassData compassData = (PlayerCompassData)stack.get(StatueDataComponents.PLAYER_COMPASS_DATA.get());
                    if (compassData != null) {
                        blockpos = compassData.pos();
                    }
                    if (blockpos != null && !(entity.distanceToSqr((double)blockpos.getX() + 0.5, entity.position().y(), (double)blockpos.getZ() + 0.5) < (double)1.0E-5f)) {
                        double d3;
                        boolean flag = entity instanceof Player && ((Player)entity).isLocalPlayer();
                        double d1 = 0.0;
                        if (flag) {
                            d1 = entityIn.getYRot();
                        } else if (entity instanceof ItemFrame) {
                            d1 = this.getFrameRotation((ItemFrame)entity);
                        } else if (entity instanceof ItemEntity) {
                            d1 = 180.0f - ((ItemEntity)entity).getSpin(0.5f) / ((float)Math.PI * 2) * 360.0f;
                        } else if (entityIn != null) {
                            d1 = entityIn.yBodyRot;
                        }
                        d1 = Mth.positiveModulo((double)(d1 / 360.0), (double)1.0);
                        double d2 = this.getLocationToAngle(Vec3.atCenterOf((Vec3i)blockpos), (Entity)entity) / 6.2831854820251465;
                        if (flag) {
                            if (this.rotation.shouldUpdate(gameTime)) {
                                this.rotation.update(gameTime, 0.5 - (d1 - 0.25));
                            }
                            d3 = d2 + this.rotation.rotation;
                        } else {
                            d3 = 0.5 - (d1 - 0.25 - d2);
                        }
                        return Mth.positiveModulo((float)((float)d3), (float)1.0f);
                    }
                    if (this.rota.shouldUpdate(gameTime)) {
                        this.rota.update(gameTime, Math.random());
                    }
                    double d0 = this.rota.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                    return Mth.positiveModulo((float)((float)d0), (float)1.0f);
                }
                double d0 = this.rota.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                return Mth.positiveModulo((float)((float)d0), (float)1.0f);
            }

            @Nullable
            private BlockPos getWorldPos(ClientLevel level) {
                return level.dimensionType().natural() ? level.getSharedSpawnPos() : null;
            }

            private double getFrameRotation(ItemFrame itemFrameIn) {
                Direction direction = itemFrameIn.getDirection();
                int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
                return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + itemFrameIn.getRotation() * 45 + i));
            }

            private double getLocationToAngle(Vec3 location, Entity entityIn) {
                return Math.atan2(location.z() - entityIn.getZ(), location.x() - entityIn.getX());
            }
        }));
        new Thread(() -> {
            Statues.LOGGER.info("Loading Statues supporter data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/ShyNieke/StatuesMod/1.19.x/Supporters.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    block12: while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Statues.LOGGER.error("Invalid entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        SupporterType type = SupporterType.valueOf(split[1]);
                        switch (type) {
                            default: {
                                SUPPORTER.add(UUID.fromString(split[0]));
                                continue block12;
                            }
                            case TRANSLATOR: 
                        }
                        TRANSLATORS.add(UUID.fromString(split[0]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Statues.LOGGER.error("Exception loading supporter data!");
                    Statues.LOGGER.trace("Trace", (Throwable)ex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Statues.LOGGER.info("Loaded {} supporters.", (Object)SUPPORTER.size());
            Statues.LOGGER.info("Loaded {} translators.", (Object)TRANSLATORS.size());
        }, "Statues Perks Data Loader").start();
        if (ModList.get().isLoaded("curios")) {
            StatueCurioRenderer.setupRenderer();
        }
    }

    public static void onRegisterMenu(RegisterMenuScreensEvent event) {
        event.register(StatueRegistry.STATUE_TABLE_MENU.get(), StatueTableScreen::new);
        event.register(StatueRegistry.SHULKER_STATUE_MENU.get(), ShulkerStatueScreen::new);
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(StatueBlockEntities.PLAYER.get(), PlayerBER::new);
        event.registerEntityRenderer(StatueRegistry.PLAYER_STATUE_ENTITY.get(), PlayerStatueRenderer::new);
        event.registerEntityRenderer(StatueRegistry.STATUE_BAT.get(), StatueBatRenderer::new);
        event.registerBlockEntityRenderer(StatueBlockEntities.STATUE_TABLE.get(), StatueTableBER::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PLAYER_STATUE, () -> LayerDefinition.create((MeshDefinition)PlayerStatueModel.createStatueMesh(CubeDeformation.NONE, false), (int)64, (int)64));
        event.registerLayerDefinition(PLAYER_STATUE_SLIM, () -> LayerDefinition.create((MeshDefinition)PlayerStatueModel.createStatueMesh(CubeDeformation.NONE, true), (int)64, (int)64));
    }

    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(FishStatueBlock::getColor, new Block[]{(Block)StatueRegistry.TROPICAL_FISH_B.get(), (Block)StatueRegistry.TROPICAL_FISH_BB.get(), (Block)StatueRegistry.TROPICAL_FISH_BE.get(), (Block)StatueRegistry.TROPICAL_FISH_BM.get(), (Block)StatueRegistry.TROPICAL_FISH_BMB.get(), (Block)StatueRegistry.TROPICAL_FISH_BMS.get(), (Block)StatueRegistry.TROPICAL_FISH_E.get(), (Block)StatueRegistry.TROPICAL_FISH_ES.get(), (Block)StatueRegistry.TROPICAL_FISH_HB.get(), (Block)StatueRegistry.TROPICAL_FISH_SB.get(), (Block)StatueRegistry.TROPICAL_FISH_SD.get(), (Block)StatueRegistry.TROPICAL_FISH_SS.get()});
    }

    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isLocalServer()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    public static void onRespawn(ClientPlayerNetworkEvent.Clone event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isLocalServer()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    private static void setPlayerCache(Minecraft mc) {
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(mc.getProxy());
        Services services = Services.create((YggdrasilAuthenticationService)authenticationService, (File)mc.gameDirectory);
        services.profileCache().setExecutor((Executor)mc);
        PlayerBlockEntity.setup(services, (Executor)mc);
        GameProfileCache.setUsesAuthentication((boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Angle {
        private double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean shouldUpdate(long p_239448_1_) {
            return this.lastUpdateTick != p_239448_1_;
        }

        private void update(long updateTick, double p_239449_3_) {
            this.lastUpdateTick = updateTick;
            double d0 = p_239449_3_ - this.rotation;
            d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

