/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.model.PlayerStatueModel;
import com.shynieke.statues.entity.PlayerStatue;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.ResolvableProfile;

public class PlayerStatueRenderer
extends LivingEntityRenderer<PlayerStatue, PlayerStatueModel> {
    private final PlayerStatueModel playerModel;
    private final PlayerStatueModel slimPlayerModel;
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.getDefaultTexture();
    public boolean isSlim = false;

    public PlayerStatueRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public PlayerStatueRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerStatueModel(context.bakeLayer(ModelLayers.PLAYER), slim), 0.0f);
        this.playerModel = new PlayerStatueModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.slimPlayerModel = new PlayerStatueModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(PlayerStatue playerStatue) {
        return playerStatue.getGameProfile().map(this::getSkin).orElse(defaultTexture);
    }

    private ResourceLocation getSkin(ResolvableProfile resolvableProfile) {
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        if (resolvableProfile != null) {
            return skinmanager.getInsecureSkin(resolvableProfile.gameProfile()).texture();
        }
        return defaultTexture;
    }

    public void render(PlayerStatue playerStatue, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        if (playerStatue.getGameProfile().isPresent() && this.isSlim != skinmanager.getInsecureSkin(playerStatue.getGameProfile().get().gameProfile()).model().id().equals("slim")) {
            this.isSlim = !this.isSlim;
        }
        this.model = this.isSlim ? this.slimPlayerModel : this.playerModel;
        poseStack.translate(0.0f, playerStatue.getYOffsetData(), 0.0f);
        if (playerStatue.clientLock > 0) {
            playerStatue.xRotO = playerStatue.yBodyRot;
            playerStatue.yHeadRotO = playerStatue.yHeadRot;
        }
        super.render((LivingEntity)playerStatue, entityYaw, partialTicks, poseStack, bufferSource, PlayerStatueRenderer.isSupporter(playerStatue) ? 0xF000F0 : packedLightIn);
    }

    protected boolean shouldShowName(PlayerStatue playerStatue) {
        return playerStatue.isCustomNameVisible();
    }

    protected void setupRotations(PlayerStatue playerStatue, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        float f = (float)(playerStatue.level().getGameTime() - playerStatue.punchCooldown) + partialTicks;
        if (f < 5.0f) {
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (PlayerStatueRenderer.isPlayerUpsideDown(playerStatue)) {
            poseStack.translate(0.0, (double)(playerStatue.getBbHeight() + 0.1f), 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected void scale(PlayerStatue playerStatue, PoseStack poseStack, float partialTickTime) {
        float f = 0.9375f;
        poseStack.scale(f, f, f);
    }

    public static boolean isPlayerUpsideDown(PlayerStatue playerStatue) {
        if (playerStatue.getGameProfile().isPresent()) {
            ResolvableProfile profile = playerStatue.getGameProfile().get();
            String s = ChatFormatting.stripFormatting((String)profile.name().orElse("steve"));
            return "Dinnerbone".equals(s) || "Grumm".equals(s);
        }
        return false;
    }

    public static boolean isSupporter(PlayerStatue playerStatue) {
        if (playerStatue.getGameProfile().isPresent()) {
            ResolvableProfile profile = playerStatue.getGameProfile().get();
            return ClientHandler.SUPPORTER.contains(profile.id().orElse(Util.NIL_UUID));
        }
        return false;
    }
}

