/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.client.screen.widget.DecimalNumberFieldBox;
import com.shynieke.statues.client.screen.widget.EnumCycleButton;
import com.shynieke.statues.client.screen.widget.NumberFieldBox;
import com.shynieke.statues.client.screen.widget.ToggleButton;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.network.message.PlayerStatueSyncData;
import java.util.Objects;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class PlayerPoseScreen
extends Screen {
    private final PlayerStatue playerStatueEntity;
    private final PlayerStatueData playerStatueData;
    private final String[] buttonLabels = new String[]{"small", "rotation", "y_offset", "locked", "name_visible", "gravity", "model_type"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private NumberFieldBox rotationTextField;
    private DecimalNumberFieldBox YOffsetTextField;
    private ToggleButton smallButton;
    private ToggleButton lockButton;
    private ToggleButton nameVisibleButton;
    private ToggleButton noGravityButton;
    private EnumCycleButton forceModelType;
    private final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private final boolean allowScrolling;
    private Vec3 lastSendOffset = new Vec3(0.0, 0.0, 0.0);

    public PlayerPoseScreen(PlayerStatue playerStatue) {
        super(GameNarrator.NO_TITLE);
        int i;
        this.playerStatueEntity = playerStatue;
        this.playerStatueData = new PlayerStatueData();
        this.playerStatueData.readFromNBT(this.playerStatueEntity.saveWithoutId(new CompoundTag()));
        this.allowScrolling = (Boolean)StatuesConfig.CLIENT.allowScrolling.get();
        for (i = 0; i < this.buttonLabels.length; ++i) {
            this.buttonLabels[i] = I18n.get((String)String.format("%s.playerstatue.gui.label." + this.buttonLabels[i], "statues"), (Object[])new Object[0]);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            this.sliderLabels[i] = I18n.get((String)String.format("%s.playerstatue.gui.label." + this.sliderLabels[i], "statues"), (Object[])new Object[0]);
        }
    }

    public static void openScreen(PlayerStatue playerStatue) {
        Minecraft.getInstance().setScreen((Screen)new PlayerPoseScreen(playerStatue));
    }

    protected void init() {
        super.init();
        int offsetX = 110;
        int offsetY = 50;
        int rowOffset = 22;
        this.smallButton = new ToggleButton.Builder(this.playerStatueData.isSmall(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }).bounds(offsetX, offsetY, 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.smallButton);
        this.rotationTextField = new NumberFieldBox(this.font, 1 + offsetX, 1 + offsetY + rowOffset, 38, 17, (Component)Component.translatable((String)"statues.playerstatue.gui.label.rotation"));
        this.rotationTextField.setValue(String.valueOf((int)this.playerStatueData.rotation));
        this.rotationTextField.setMaxLength(4);
        this.addWidget((GuiEventListener)this.rotationTextField);
        this.YOffsetTextField = new DecimalNumberFieldBox(this.font, 1 + offsetX, 1 + offsetY + rowOffset * 2, 38, 17, (Component)Component.translatable((String)"statues.playerstatue.gui.label.y_offset"));
        this.YOffsetTextField.setValue(String.valueOf(Mth.clamp((float)this.playerStatueData.yOffset, (float)-1.0f, (float)1.0f)));
        this.YOffsetTextField.setMaxLength(5);
        this.addWidget((GuiEventListener)this.YOffsetTextField);
        this.lockButton = new ToggleButton.Builder(this.playerStatueData.isLocked(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }).bounds(offsetX, offsetY + rowOffset * 3, 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.nameVisibleButton = new ToggleButton.Builder(this.playerStatueData.getNameVisible(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }).bounds(offsetX, offsetY + rowOffset * 4, 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.nameVisibleButton);
        this.noGravityButton = new ToggleButton.Builder(this.playerStatueData.hasNoGravity(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }).bounds(offsetX, offsetY + rowOffset * 5, 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.noGravityButton);
        this.forceModelType = new EnumCycleButton.Builder(this.playerStatueData.modelType, "modeltype", (Enum[])PlayerStatueData.MODEL_TYPE.values(), button -> {
            EnumCycleButton optionCycleButton = (EnumCycleButton)button;
            optionCycleButton.cycleValue();
            this.textFieldUpdated();
        }).bounds(offsetX, offsetY + rowOffset * 6, 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.forceModelType);
        offsetX = this.width - 20 - 100;
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            int x = 1 + offsetX + i % 3 * 35;
            int y = 1 + offsetY + i / 3 * 22;
            int width = 28;
            int height = 17;
            String value = String.valueOf((int)this.playerStatueData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.font, x, y, width, height, (Component)Component.literal((String)value));
            this.poseTextFields[i].setValue(value);
            this.poseTextFields[i].setMaxLength(4);
            if (i >= 18 && i < 21) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].setMaxLength(6);
            }
            this.addWidget((GuiEventListener)this.poseTextFields[i]);
        }
        offsetX = 20;
        offsetY = this.height / 4 + 134 + 12;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"statues.playerstatue.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.minecraft != null) {
                this.minecraft.keyboardHandler.setClipboard(clipboardData);
            }
        }).bounds(offsetX, offsetY, 64, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"statues.playerstatue.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.minecraft != null) {
                    clipboardData = this.minecraft.keyboardHandler.getClipboard();
                }
                if (clipboardData != null) {
                    CompoundTag compound = TagParser.parseTag(clipboardData);
                    this.readFieldsFromNBT(compound);
                    this.updateEntity(compound);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).bounds(offsetX + 66, offsetY, 64, 20).build());
        offsetX = this.width - 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            this.updateEntity(this.writeFieldsToNBT());
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 194, offsetY, 96, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> {
            this.poseTextFields[18].setValue("0");
            this.poseTextFields[19].setValue("0");
            this.poseTextFields[20].setValue("0");
            this.textFieldUpdated();
            this.updateEntity(this.playerStatueData.writeToNBT());
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 96, offsetY, 96, 20).build());
    }

    public void onClose() {
        super.onClose();
        this.playerStatueEntity.clientLock = 0;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int y;
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)String.format("%s.playerstatue.gui.title", "statues"), (Object[])new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.rotationTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.YOffsetTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            if (textField == null) continue;
            textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        int offsetY = 50;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.font);
            y = offsetY + i * 22 + (11 - 9 / 2);
            guiGraphics.drawString(this.font, this.buttonLabels[i], x, y, 0xA0A0A0, false);
        }
        offsetX = this.width - 20 - 100;
        guiGraphics.drawString(this.font, "X", offsetX, 37, 0xA0A0A0, false);
        guiGraphics.drawString(this.font, "Y", offsetX + 35, 37, 0xA0A0A0, false);
        guiGraphics.drawString(this.font, "Z", offsetX + 70, 37, 0xA0A0A0, false);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            int x = offsetX - this.font.width(this.sliderLabels[i]) - 10;
            Objects.requireNonNull(this.font);
            y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.drawString(this.font, this.sliderLabels[i], x, y, 0xA0A0A0, false);
        }
    }

    public void tick() {
        super.tick();
        this.playerStatueEntity.clientLock = 5;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        boolean typed = super.charTyped(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double delta2) {
        block5: {
            float multiplier;
            block4: {
                float f = multiplier = Screen.hasShiftDown() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(delta > 0.0)) break block4;
                if (this.rotationTextField.isFocused()) {
                    float nextValue = (this.rotationTextField.getFloat() + multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                    this.rotationTextField.setValue(String.valueOf(nextValue));
                    this.rotationTextField.setCursorPosition(0);
                    this.rotationTextField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.isHoveredOrFocused()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.setValue(String.valueOf(nextValue));
                    textField.setCursorPosition(0);
                    textField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block5;
            }
            if (!this.allowScrolling || !(delta < 0.0)) break block5;
            if (this.rotationTextField.isFocused()) {
                float previousValue = (this.rotationTextField.getFloat() - multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                this.rotationTextField.setValue(String.valueOf(previousValue));
                this.rotationTextField.setCursorPosition(0);
                this.rotationTextField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.isHoveredOrFocused()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.setValue(String.valueOf(previousValue));
                textField.setCursorPosition(0);
                textField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, delta, delta2);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].isFocused()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].moveCursorToEnd(false);
                this.poseTextFields[i].setFocused(false);
                int j = !Screen.hasShiftDown() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].setFocused(true);
                this.poseTextFields[j].moveCursorTo(0, false);
                this.poseTextFields[j].setHighlightPos(this.poseTextFields[j].getValue().length());
            }
        } else {
            if (this.rotationTextField.keyPressed(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.YOffsetTextField.keyPressed(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            this.textFieldUpdated();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.rotationTextField.mouseClicked(mouseX, mouseY, button);
        this.YOffsetTextField.mouseClicked(mouseX, mouseY, button);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.mouseClicked(mouseX, mouseY, button);
        }
        this.textFieldUpdated();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    private CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Small", this.smallButton.getValue());
        compound.putBoolean("Locked", this.lockButton.getValue());
        compound.putBoolean("CustomNameVisible", this.nameVisibleButton.getValue());
        compound.putBoolean("NoGravity", this.noGravityButton.getValue());
        compound.putDouble("yOffset", (double)this.YOffsetTextField.getFloat());
        compound.putString("Model", ((Enum)this.forceModelType.getValue()).name());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.valueOf((float)this.rotationTextField.getFloat()));
        compound.put("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[2].getFloat()));
        poseTag.put("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[5].getFloat()));
        poseTag.put("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[8].getFloat()));
        poseTag.put("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[11].getFloat()));
        poseTag.put("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[14].getFloat()));
        poseTag.put("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[17].getFloat()));
        poseTag.put("RightArm", (Tag)poseRightArmTag);
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.x;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.y;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.z;
        ListTag positionOffset = new ListTag();
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetXDiff));
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetYDiff));
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetZDiff));
        compound.put("Move", (Tag)positionOffset);
        this.lastSendOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }

    private void readFieldsFromNBT(CompoundTag compound) {
        PlayerStatueData statueData = new PlayerStatueData();
        statueData.readFromNBT(compound);
        this.smallButton.setValue(statueData.small);
        this.lockButton.setValue(statueData.locked);
        this.nameVisibleButton.setValue(statueData.nameVisible);
        this.noGravityButton.setValue(statueData.noGravity);
        this.YOffsetTextField.setValue(String.valueOf((double)statueData.yOffset));
        this.rotationTextField.setValue(String.valueOf((int)statueData.rotation));
        this.forceModelType.setValue(this.forceModelType.findValue(statueData.modelType));
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            this.poseTextFields[i].setValue(String.valueOf((int)statueData.pose[i]));
        }
    }

    private void updateEntity(CompoundTag compound) {
        CompoundTag CompoundTag2 = this.playerStatueEntity.saveWithoutId(new CompoundTag()).copy();
        CompoundTag2.merge(compound);
        this.playerStatueEntity.clientLock = 0;
        this.playerStatueEntity.load(CompoundTag2);
        this.playerStatueEntity.clientLock = 5;
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerStatueSyncData(this.playerStatueEntity.getUUID(), compound), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

